/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class ATN2Function
extends AbstractNumericFunction {
    public static final String NAME = "ATN2";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "The the arc-tangent of a number.", 0, false, 5), new Column("number1", ParadoxType.NUMBER, "A numeric value.", 1, false, 1), new Column("number2", ParadoxType.NUMBER, "A numeric value.", 2, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the arc-tangent of two numbers.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Double value1 = ValuesConverter.getDouble(values[0], connectionInfo);
        Double value2 = ValuesConverter.getDouble(values[1], connectionInfo);
        if (value1 == null || value2 == null) {
            return null;
        }
        return Math.atan2(value1, value2);
    }
}

