/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.general;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.function.general.AbstractGeneralFunction;
import com.googlecode.paradox.planner.FieldValueUtils;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.util.Objects;

public class NvlFunction
extends AbstractGeneralFunction {
    public static final String NAME = "NVL";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The string or replacement (if first is null).", 0, true, 5), new Column("string", ParadoxType.VARCHAR, "The string to test if null.", 1, true, 1), new Column("replacement", ParadoxType.VARCHAR, "The replacement in case of null.", 2, true, 1)};
    private ParadoxType type = ParadoxType.NULL;

    @Override
    public String getRemarks() {
        return "Return a specified value if the string is null.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public ParadoxType getFieldType() {
        return this.type;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws ParadoxSyntaxErrorException {
        this.type = FieldValueUtils.getSqlType(values, types);
        if (values[0] != null) {
            return values[0];
        }
        return values[1];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NvlFunction that = (NvlFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type);
    }
}

