/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.general;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.function.general.AbstractGeneralFunction;
import com.googlecode.paradox.planner.FieldValueUtils;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.util.Objects;

public class NullIfFunction
extends AbstractGeneralFunction {
    public static final String NAME = "NULLIF";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The string or replacement (if first is null).", 0, true, 5), new Column("expression1", ParadoxType.VARCHAR, "The first value to test.", 1, true, 1), new Column("expression2", ParadoxType.VARCHAR, "The second value to test.", 2, true, 1)};
    private ParadoxType type = ParadoxType.NULL;

    @Override
    public String getRemarks() {
        return "Returns null if both values are equal, otherwise it returns the first expression.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public ParadoxType getFieldType() {
        return this.type;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws ParadoxSyntaxErrorException {
        this.type = FieldValueUtils.getSqlType(values, types);
        if (Objects.equals(values[0], values[1])) {
            return null;
        }
        return values[0];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullIfFunction that = (NullIfFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type);
    }
}

