/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.general;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.general.AbstractGeneralFunction;
import com.googlecode.paradox.parser.TokenType;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class ConvertFunction
extends AbstractGeneralFunction {
    public static final String NAME = "CONVERT";
    private boolean convertCharset;
    private Charset charset;
    private ParadoxType type = ParadoxType.VARCHAR;
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The string converted with charset specified.", 0, true, 5), new Column("value", ParadoxType.VARCHAR, "The value to convert.", 1, true, 1), new Column("charset", ParadoxType.VARCHAR, "The charset name to convert.", 2, true, 1)};

    @Override
    public String getRemarks() {
        return "Convert a string to charset specified. Example: CONVERT('value' USING utf8)";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public ParadoxType getFieldType() {
        return this.type;
    }

    @Override
    public int getMaxParameterCount() {
        return 3;
    }

    @Override
    public boolean isVariableParameters() {
        return true;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        if (this.convertCharset) {
            Object value = values[0];
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                Charset original = StandardCharsets.UTF_8;
                FieldNode field = fields[0];
                if (field != null && field.getTable() != null) {
                    original = field.getTable().getCharset();
                }
                byte[] bytes = ((String)value).getBytes(original);
                return new String(bytes, this.charset);
            }
            if (value instanceof byte[]) {
                return ValuesConverter.convert((byte[])value, this.charset).replace("\u0000", "");
            }
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, value);
        }
        return ValuesConverter.convert(values[0], this.type, connectionInfo);
    }

    @Override
    public void validate(List<SQLNode> parameters) throws ParadoxSyntaxErrorException {
        super.validate(parameters);
        if (parameters.size() == 3) {
            if (!parameters.get(1).getName().equalsIgnoreCase(TokenType.USING.name())) {
                throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, parameters.get(1).getPosition());
            }
            SQLNode charsetNode = parameters.get(2);
            try {
                this.charset = Charset.forName(charsetNode.getName());
            }
            catch (UnsupportedCharsetException e) {
                throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, charsetNode.getPosition(), charsetNode.getName(), e);
            }
            this.convertCharset = true;
            parameters.remove(2);
            parameters.remove(1);
        } else {
            SQLNode typeNode = parameters.get(1);
            if (typeNode instanceof FieldNode) {
                try {
                    this.type = ParadoxType.valueOf(typeNode.getName());
                    parameters.remove(1);
                }
                catch (IllegalArgumentException e) {
                    throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, typeNode.getName(), typeNode.getPosition());
                }
            } else {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, typeNode.getName(), typeNode.getPosition());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertFunction that = (ConvertFunction)o;
        return this.convertCharset == that.convertCharset && Objects.equals(this.charset, that.charset) && this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.convertCharset, this.charset, this.type);
    }
}

