/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.general;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.general.AbstractGeneralFunction;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class CastFunction
extends AbstractGeneralFunction {
    public static final String NAME = "CAST";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.BYTES, "The converted field.", 0, true, 5), new Column("value", ParadoxType.VARCHAR, "The value to convert.", 1, true, 1), new Column("sql_type", ParadoxType.VARCHAR, "The SQL type to convert.", 2, true, 1)};
    private ParadoxType type = ParadoxType.BYTES;

    @Override
    public String getRemarks() {
        return "Converts a field type to another.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public ParadoxType getFieldType() {
        return this.type;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        return ValuesConverter.convert(values[0], this.type, connectionInfo);
    }

    @Override
    public void validate(List<SQLNode> parameters) throws ParadoxSyntaxErrorException {
        super.validate(parameters);
        SQLNode typeNode = parameters.get(1);
        if (typeNode instanceof FieldNode) {
            try {
                this.type = ParadoxType.valueOf(typeNode.getName().toUpperCase());
                parameters.remove(1);
            }
            catch (IllegalArgumentException e) {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, typeNode.getName(), typeNode.getPosition());
            }
        } else {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, typeNode.getName(), typeNode.getPosition());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CastFunction that = (CastFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type);
    }
}

