/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.general;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.general.AbstractGeneralFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class BinaryFunction
extends AbstractGeneralFunction {
    public static final String NAME = "BINARY";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.BLOB, "The BLOB value.", 0, false, 5), new Column("value", ParadoxType.NUMBER, "A value to convert.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the square root of a number.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        return ValuesConverter.getByteArray(values[0], connectionInfo);
    }
}

