/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;

public class LastDayFunction
extends AbstractDateFunction {
    public static final String NAME = "LAST_DAY";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.DATE, "The date with the last day of the month.", 0, false, 5), new Column("date", ParadoxType.TIMESTAMP, "The time/datetime to extract the last day from.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Extract the last day of the month for a given date.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        Date date = ValuesConverter.getDate(values[0], connectionInfo);
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        return ValuesConverter.removeTime(c.getTime());
    }
}

