/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class IsDateFunction
extends AbstractDateFunction {
    public static final String NAME = "ISDATE";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.BOOLEAN, "True if the value is date.", 0, false, 5), new Column("date", ParadoxType.DATE, "The value to check.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Checks if the value can be a date or time value.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        if (ValuesConverter.getDate(values[0], connectionInfo) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

