/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.function.date.TimeIntervalType;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import com.googlecode.paradox.utils.Utils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;

public class ExtractFunction
extends AbstractDateFunction {
    public static final String NAME = "EXTRACT";
    private TimeIntervalType type;
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.INTEGER, "The part of the.", 0, false, 5), new Column("date_part", ParadoxType.VARCHAR, "The part name to extract.", 1, false, 1), new Column("date", ParadoxType.TIMESTAMP, "The date to extract.", 2, false, 1)};

    private static Calendar getTime(Object value, ConnectionInfo connectionInfo) {
        Time time = ValuesConverter.getTime(value, connectionInfo);
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        return c;
    }

    private static Calendar getTimestamp(Object value, ConnectionInfo connectionInfo) {
        Timestamp timestamp = ValuesConverter.getTimestamp(value, connectionInfo);
        Calendar c = Calendar.getInstance();
        c.setTime(timestamp);
        return c;
    }

    private static Calendar getDate(Object value, ConnectionInfo connectionInfo) {
        Date time = ValuesConverter.getDate(value, connectionInfo);
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        return c;
    }

    @Override
    public String getRemarks() {
        return "Extract a value from date/time.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        Object value = values[1];
        int ret = 0;
        switch (this.type) {
            case MILLISECOND: {
                ret = ExtractFunction.getTimestamp(value, connectionInfo).get(14);
                break;
            }
            case SECOND: {
                ret = ExtractFunction.getTime(value, connectionInfo).get(13);
                break;
            }
            case MINUTE: {
                ret = ExtractFunction.getTime(value, connectionInfo).get(12);
                break;
            }
            case HOUR: {
                ret = ExtractFunction.getTime(value, connectionInfo).get(11);
                break;
            }
            case DAY: {
                ret = ExtractFunction.getDate(value, connectionInfo).get(5);
                break;
            }
            case DAYOFYEAR: {
                ret = ExtractFunction.getDate(value, connectionInfo).get(6);
                break;
            }
            case MONTH: {
                ret = ExtractFunction.getDate(value, connectionInfo).get(2) + 1;
                break;
            }
            case YEAR: {
                ret = ExtractFunction.getDate(value, connectionInfo).get(1);
                break;
            }
            case WEEK: {
                ret = ExtractFunction.getDate(value, connectionInfo).get(3);
                break;
            }
            case QUARTER: {
                ret = ExtractFunction.getDate(value, connectionInfo).get(2) / 3 + 1;
            }
        }
        return ret;
    }

    @Override
    public void validate(List<SQLNode> parameters) throws ParadoxSyntaxErrorException {
        super.validate(parameters);
        SQLNode value = parameters.get(0);
        this.type = Utils.searchEnum(TimeIntervalType.class, value.getName());
        if (this.type == null) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, value.getName());
        }
        parameters.set(0, new ValueNode(value.getName().toUpperCase(), value.getPosition(), ParadoxType.VARCHAR));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtractFunction that = (ExtractFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }
}

