/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.Date;
import java.sql.SQLException;
import java.util.GregorianCalendar;

public class DateFromPartsFunction
extends AbstractDateFunction {
    public static final String NAME = "DATEFROMPARTS";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.DATE, "The date value.", 0, false, 5), new Column("year", ParadoxType.INTEGER, "Specifies a year (4 digits).", 1, false, 1), new Column("month", ParadoxType.INTEGER, "Specifies a month (from 1 to 12).", 2, false, 1), new Column("day", ParadoxType.INTEGER, "Specifies a day (from 1 to 31).", 3, false, 1)};

    @Override
    public String getRemarks() {
        return "Extract a date from the specified parts (year, month, and day values).";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        Integer year = ValuesConverter.getInteger(values[0], connectionInfo);
        Integer month = ValuesConverter.getInteger(values[1], connectionInfo);
        Integer day = ValuesConverter.getInteger(values[2], connectionInfo);
        if (year == null || month == null || day == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar(year, month - 1, day);
        return new Date(c.getTimeInMillis());
    }
}

