/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.function.date.TimeIntervalType;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import com.googlecode.paradox.utils.Utils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;

public class DateDiffFunction
extends AbstractDateFunction {
    public static final String NAME = "DATEDIFF";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.BCD, "The difference between dates.", 0, false, 5), new Column("interval", ParadoxType.VARCHAR, "The date interval to compare.", 1, false, 1), new Column("start_date", ParadoxType.TIMESTAMP, "The start date.", 2, false, 1), new Column("end_date", ParadoxType.TIMESTAMP, "The end date.", 3, false, 1)};
    private TimeIntervalType type;

    @Override
    public String getRemarks() {
        return "Returns the difference between two dates.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        Timestamp beginDate = ValuesConverter.getTimestamp(values[1], connectionInfo);
        Timestamp endDate = ValuesConverter.getTimestamp(values[2], connectionInfo);
        if (beginDate == null || endDate == null) {
            return null;
        }
        Instant localBeginDate = Instant.ofEpochMilli(beginDate.getTime());
        Instant localEndDate = Instant.ofEpochMilli(endDate.getTime());
        ZoneId zoneId = ZoneId.of(connectionInfo.getTimeZone().getID());
        LocalDateTime localDate1 = LocalDateTime.ofInstant(localBeginDate, zoneId);
        LocalDateTime localDate2 = LocalDateTime.ofInstant(localEndDate, zoneId);
        Period period = Period.between(localDate1.toLocalDate(), localDate2.toLocalDate());
        long ret = 0L;
        switch (this.type) {
            case MILLISECOND: {
                ret = ChronoUnit.MILLIS.between(localBeginDate, localEndDate);
                break;
            }
            case SECOND: {
                ret = ChronoUnit.SECONDS.between(localBeginDate, localEndDate);
                break;
            }
            case MINUTE: {
                ret = ChronoUnit.MINUTES.between(localBeginDate, localEndDate);
                break;
            }
            case HOUR: {
                ret = ChronoUnit.HOURS.between(localBeginDate, localEndDate);
                break;
            }
            case DAY: 
            case DAYOFYEAR: {
                ret = ChronoUnit.DAYS.between(localBeginDate, localEndDate);
                break;
            }
            case MONTH: {
                ret = period.toTotalMonths();
                break;
            }
            case YEAR: {
                ret = period.getYears();
                break;
            }
            case WEEK: {
                ret = ChronoUnit.DAYS.between(localBeginDate, localEndDate) / 7L;
                break;
            }
            case QUARTER: {
                ret = period.toTotalMonths() / 3L;
            }
        }
        return ret;
    }

    @Override
    public void validate(List<SQLNode> parameters) throws ParadoxSyntaxErrorException {
        super.validate(parameters);
        SQLNode value = parameters.get(0);
        this.type = Utils.searchEnum(TimeIntervalType.class, value.getName());
        if (this.type == null) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, value.getName());
        }
        parameters.set(0, new ValueNode(value.getName().toUpperCase(), value.getPosition(), ParadoxType.VARCHAR));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateDiffFunction that = (DateDiffFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }
}

