/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.function.date.TimeIntervalType;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import com.googlecode.paradox.utils.Utils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;

public class DateAddFunction
extends AbstractDateFunction {
    public static final String NAME = "DATEADD";
    private TimeIntervalType type;
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.TIMESTAMP, "The result date.", 0, false, 5), new Column("format", ParadoxType.VARCHAR, "The interval format.", 1, false, 1), new Column("number", ParadoxType.INTEGER, "The value to add.", 2, false, 1), new Column("date", ParadoxType.TIMESTAMP, "The date to add.", 3, false, 1)};

    @Override
    public String getRemarks() {
        return "Adds a time/date interval to a date and then returns the date.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        Integer number = ValuesConverter.getInteger(values[1], connectionInfo);
        Timestamp timestamp = ValuesConverter.getTimestamp(values[2], connectionInfo);
        if (number == null || timestamp == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(timestamp);
        switch (this.type) {
            case MILLISECOND: {
                c.add(14, number);
                break;
            }
            case SECOND: {
                c.add(13, number);
                break;
            }
            case MINUTE: {
                c.add(12, number);
                break;
            }
            case HOUR: {
                c.add(11, number);
                break;
            }
            case DAY: {
                c.add(5, number);
                break;
            }
            case DAYOFYEAR: {
                c.add(6, number);
                break;
            }
            case MONTH: {
                c.add(2, number);
                break;
            }
            case YEAR: {
                c.add(1, number);
                break;
            }
            case WEEK: {
                c.add(4, number);
                break;
            }
            case QUARTER: {
                c.add(2, number * 3);
            }
        }
        return new Timestamp(c.getTimeInMillis());
    }

    @Override
    public void validate(List<SQLNode> parameters) throws ParadoxSyntaxErrorException {
        super.validate(parameters);
        SQLNode value = parameters.get(0);
        this.type = Utils.searchEnum(TimeIntervalType.class, value.getName());
        if (this.type == null) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, value.getName());
        }
        parameters.set(0, new ValueNode(value.getName().toUpperCase(), value.getPosition(), ParadoxType.VARCHAR));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateAddFunction that = (DateAddFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }
}

