/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.Timestamp;
import java.util.TimeZone;

public class CurrentTimestampFunction
extends AbstractDateFunction {
    public static final String NAME = "CURRENT_TIMESTAMP";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.TIMESTAMP, "The current timestamp.", 0, false, 5)};

    @Override
    public String getRemarks() {
        return "Gets the current timestamp.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public boolean isAllowAlias() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        long time = System.currentTimeMillis();
        return new Timestamp(time + (long)connectionInfo.getTimeZone().getOffset(time) - (long)TimeZone.getDefault().getOffset(time));
    }
}

