/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;
import java.sql.Time;
import java.util.TimeZone;

public class CurrentTimeFunction
extends AbstractDateFunction {
    public static final String NAME = "CURRENT_TIME";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.TIME, "The current time.", 0, false, 5), new Column("precision", ParadoxType.INTEGER, "The time precision from 0 to 6. Ignored", 1, true, 1)};

    @Override
    public String getRemarks() {
        return "Gets the current time.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public boolean isAllowAlias() {
        return true;
    }

    @Override
    public boolean isVariableParameters() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public int getParameterCount() {
        return 0;
    }

    @Override
    public int getMaxParameterCount() {
        return 1;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        int value;
        if (types.length == 1 && ((value = ValuesConverter.getPositiveInteger(values[0], connectionInfo)) < 0 || value > 6)) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, value);
        }
        long time = System.currentTimeMillis();
        return ValuesConverter.removeDate(new Time(time + (long)connectionInfo.getTimeZone().getOffset(time) - (long)TimeZone.getDefault().getOffset(time)));
    }
}

