/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.date;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.date.AbstractDateFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.Date;
import java.util.TimeZone;

public class CurrentDateFunction
extends AbstractDateFunction {
    public static final String NAME = "CURRENT_DATE";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.DATE, "The current date.", 0, false, 5)};

    @Override
    public String getRemarks() {
        return "Gets the current date.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public boolean isAllowAlias() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        long time = System.currentTimeMillis();
        return ValuesConverter.removeTime(new Date(time + (long)connectionInfo.getTimeZone().getOffset(time) - (long)TimeZone.getDefault().getOffset(time)));
    }
}

