/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.aggregate.context;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.aggregate.IGroupingContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AvgContext
implements IGroupingContext<BigDecimal> {
    private BigDecimal value;
    private int total = 1;

    public AvgContext(BigDecimal value) {
        this.value = value;
    }

    @Override
    public void process(IGroupingContext<BigDecimal> context, ConnectionInfo connectionInfo) {
        AvgContext current = (AvgContext)context;
        if (current != null) {
            this.total += current.total;
            if (this.value == null) {
                this.value = current.value;
            } else if (current.value != null) {
                this.value = this.value.add(current.value);
            }
        }
    }

    @Override
    public BigDecimal toValue() {
        if (this.value != null && this.total != 0) {
            return this.value.divide(BigDecimal.valueOf(this.total), RoundingMode.FLOOR);
        }
        return null;
    }

    public String toString() {
        return this.value.toString();
    }
}

