/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.aggregate;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.aggregate.AbstractGroupingFunction;
import com.googlecode.paradox.function.aggregate.context.MinContext;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.math.BigDecimal;
import java.util.List;

public class MinFunction
extends AbstractGroupingFunction<BigDecimal> {
    public static final String NAME = "MIN";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "The minimum of the values.", 0, true, 5), new Column("value", ParadoxType.NUMBER, "The numeric value to check.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the minimum of a set of values.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public MinContext execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        BigDecimal value = ValuesConverter.getBigDecimal(values[0], connectionInfo);
        return new MinContext(value);
    }

    @Override
    public void validate(List<SQLNode> parameters) {
    }
}

