/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.aggregate;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.aggregate.AbstractGroupingFunction;
import com.googlecode.paradox.function.aggregate.context.CountContext;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.util.List;

public class CountFunction
extends AbstractGroupingFunction<Integer> {
    public static final String NAME = "COUNT";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.LONG, "The number of rows.", 0, true, 5), new Column("value", ParadoxType.NULL, "Any value to count.", 1, true, 1)};

    @Override
    public String getRemarks() {
        return "Returns the number of rows that value is not null.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public CountContext execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        int value = 0;
        if (values[0] != null) {
            value = 1;
        }
        return new CountContext(value);
    }

    @Override
    public void validate(List<SQLNode> parameters) {
    }
}

