/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.aggregate;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.aggregate.AbstractGroupingFunction;
import com.googlecode.paradox.function.aggregate.context.AvgContext;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.math.BigDecimal;
import java.util.List;

public class AvgFunction
extends AbstractGroupingFunction<BigDecimal> {
    public static final String NAME = "AVG";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.BCD, "The average of the values.", 0, true, 5), new Column("value", ParadoxType.BCD, "The numeric value to check.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the average of a set of values.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public AvgContext execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        BigDecimal value = ValuesConverter.getBigDecimal(values[0], connectionInfo);
        return new AvgContext(value);
    }

    @Override
    public void validate(List<SQLNode> parameters) {
    }
}

