/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function;

import com.googlecode.paradox.function.AbstractFunction;
import com.googlecode.paradox.function.FunctionType;
import com.googlecode.paradox.function.aggregate.AvgFunction;
import com.googlecode.paradox.function.aggregate.CountFunction;
import com.googlecode.paradox.function.aggregate.MaxFunction;
import com.googlecode.paradox.function.aggregate.MinFunction;
import com.googlecode.paradox.function.aggregate.SumFunction;
import com.googlecode.paradox.function.date.CurrentDateFunction;
import com.googlecode.paradox.function.date.CurrentTimeFunction;
import com.googlecode.paradox.function.date.CurrentTimestampFunction;
import com.googlecode.paradox.function.date.DateAddFunction;
import com.googlecode.paradox.function.date.DateDiffFunction;
import com.googlecode.paradox.function.date.DateFromPartsFunction;
import com.googlecode.paradox.function.date.DateFunction;
import com.googlecode.paradox.function.date.DayFunction;
import com.googlecode.paradox.function.date.DayOfWeekFunction;
import com.googlecode.paradox.function.date.DayOfYearFunction;
import com.googlecode.paradox.function.date.ExtractFunction;
import com.googlecode.paradox.function.date.HourFunction;
import com.googlecode.paradox.function.date.IsDateFunction;
import com.googlecode.paradox.function.date.LastDayFunction;
import com.googlecode.paradox.function.date.MinuteFunction;
import com.googlecode.paradox.function.date.MonthFunction;
import com.googlecode.paradox.function.date.SecondFunction;
import com.googlecode.paradox.function.date.TimeFunction;
import com.googlecode.paradox.function.date.WeekOfYearFunction;
import com.googlecode.paradox.function.date.YearFunction;
import com.googlecode.paradox.function.general.BinaryFunction;
import com.googlecode.paradox.function.general.CastFunction;
import com.googlecode.paradox.function.general.CoalesceFunction;
import com.googlecode.paradox.function.general.ConvertFunction;
import com.googlecode.paradox.function.general.NullIfFunction;
import com.googlecode.paradox.function.general.NvlFunction;
import com.googlecode.paradox.function.numeric.ACosFunction;
import com.googlecode.paradox.function.numeric.ACotFunction;
import com.googlecode.paradox.function.numeric.ASinFunction;
import com.googlecode.paradox.function.numeric.ATN2Function;
import com.googlecode.paradox.function.numeric.ATanFunction;
import com.googlecode.paradox.function.numeric.AbsFunction;
import com.googlecode.paradox.function.numeric.BinFunction;
import com.googlecode.paradox.function.numeric.CeilingFunction;
import com.googlecode.paradox.function.numeric.CosFunction;
import com.googlecode.paradox.function.numeric.CoshFunction;
import com.googlecode.paradox.function.numeric.CotFunction;
import com.googlecode.paradox.function.numeric.DegreesFunction;
import com.googlecode.paradox.function.numeric.ExpFunction;
import com.googlecode.paradox.function.numeric.FloorFunction;
import com.googlecode.paradox.function.numeric.HexFunction;
import com.googlecode.paradox.function.numeric.IntegerFunction;
import com.googlecode.paradox.function.numeric.IsNumericFunction;
import com.googlecode.paradox.function.numeric.Log10Function;
import com.googlecode.paradox.function.numeric.LogFunction;
import com.googlecode.paradox.function.numeric.NumericFunction;
import com.googlecode.paradox.function.numeric.PiFunction;
import com.googlecode.paradox.function.numeric.PowerFunction;
import com.googlecode.paradox.function.numeric.RadiansFunction;
import com.googlecode.paradox.function.numeric.RandFunction;
import com.googlecode.paradox.function.numeric.RoundFunction;
import com.googlecode.paradox.function.numeric.SignFunction;
import com.googlecode.paradox.function.numeric.SinFunction;
import com.googlecode.paradox.function.numeric.SqrtFunction;
import com.googlecode.paradox.function.numeric.SquareFunction;
import com.googlecode.paradox.function.numeric.TanFunction;
import com.googlecode.paradox.function.string.AsciiFunction;
import com.googlecode.paradox.function.string.BitLengthFunction;
import com.googlecode.paradox.function.string.CharFunction;
import com.googlecode.paradox.function.string.CharLengthFunction;
import com.googlecode.paradox.function.string.ChrFunction;
import com.googlecode.paradox.function.string.ConcatFunction;
import com.googlecode.paradox.function.string.ConcatWSFunction;
import com.googlecode.paradox.function.string.InitCapFunction;
import com.googlecode.paradox.function.string.LPadFunction;
import com.googlecode.paradox.function.string.LeftFunction;
import com.googlecode.paradox.function.string.LowerFunction;
import com.googlecode.paradox.function.string.OctetLengthFunction;
import com.googlecode.paradox.function.string.PositionFunction;
import com.googlecode.paradox.function.string.RPadFunction;
import com.googlecode.paradox.function.string.RepeatFunction;
import com.googlecode.paradox.function.string.ReplaceFunction;
import com.googlecode.paradox.function.string.ReverseFunction;
import com.googlecode.paradox.function.string.RightFunction;
import com.googlecode.paradox.function.string.SpaceFunction;
import com.googlecode.paradox.function.string.SubstringFunction;
import com.googlecode.paradox.function.string.TextFunction;
import com.googlecode.paradox.function.string.TrimFunction;
import com.googlecode.paradox.function.string.UpperFunction;
import com.googlecode.paradox.function.string.VarcharFunction;
import com.googlecode.paradox.function.system.ConnectionIDFunction;
import com.googlecode.paradox.function.system.CurrentSchemaFunction;
import com.googlecode.paradox.function.system.DatabaseFunction;
import com.googlecode.paradox.function.system.DriverMajorVersionFunction;
import com.googlecode.paradox.function.system.DriverMinorVersionFunction;
import com.googlecode.paradox.function.system.DriverNameFunction;
import com.googlecode.paradox.function.system.UserFunction;
import com.googlecode.paradox.function.system.VersionFunction;
import com.googlecode.paradox.function.system.VersionNumberFunction;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class FunctionFactory {
    private static final SortedMap<String, Supplier<? extends AbstractFunction>> FUNCTIONS = new TreeMap<String, Supplier<? extends AbstractFunction>>();
    private static final Map<String, Supplier<? extends AbstractFunction>> FUNCTION_ALIAS;

    private FunctionFactory() {
    }

    public static Map<String, Supplier<? extends AbstractFunction>> getFunctions() {
        return Collections.unmodifiableMap(FUNCTIONS);
    }

    public static boolean isFunctionAlias(String alias) {
        if (alias != null) {
            Supplier<? extends AbstractFunction> supplier = FUNCTION_ALIAS.get(alias.toUpperCase());
            return supplier != null;
        }
        return false;
    }

    public static AbstractFunction getByName(String name) {
        Supplier supplier;
        if (name != null && (supplier = (Supplier)FUNCTIONS.get(name.toUpperCase())) != null) {
            return (AbstractFunction)supplier.get();
        }
        return null;
    }

    public static String getByType(FunctionType type) {
        return FUNCTIONS.entrySet().stream().filter(e -> ((AbstractFunction)((Supplier)e.getValue()).get()).getType() == type).map(Map.Entry::getKey).sorted().collect(Collectors.joining(","));
    }

    static {
        FUNCTIONS.put("CURRENT_DATE", CurrentDateFunction::new);
        FUNCTIONS.put("CURRENT_TIME", CurrentTimeFunction::new);
        FUNCTIONS.put("CURRENT_TIMESTAMP", CurrentTimestampFunction::new);
        FUNCTIONS.put("DATEADD", DateAddFunction::new);
        FUNCTIONS.put("DATEDIFF", DateDiffFunction::new);
        FUNCTIONS.put("DAY", DayFunction::new);
        FUNCTIONS.put("DAYOFMONTH", DayFunction::new);
        FUNCTIONS.put("DAYOFWEEK", DayOfWeekFunction::new);
        FUNCTIONS.put("DAYOFYEAR", DayOfYearFunction::new);
        FUNCTIONS.put("DATE", DateFunction::new);
        FUNCTIONS.put("DATEFROMPARTS", DateFromPartsFunction::new);
        FUNCTIONS.put("EXTRACT", ExtractFunction::new);
        FUNCTIONS.put("HOUR", HourFunction::new);
        FUNCTIONS.put("ISDATE", IsDateFunction::new);
        FUNCTIONS.put("LAST_DAY", LastDayFunction::new);
        FUNCTIONS.put("MINUTE", MinuteFunction::new);
        FUNCTIONS.put("MONTH", MonthFunction::new);
        FUNCTIONS.put("SECOND", SecondFunction::new);
        FUNCTIONS.put("SYSDATE", CurrentTimestampFunction::new);
        FUNCTIONS.put("TIME", TimeFunction::new);
        FUNCTIONS.put("WEEK", WeekOfYearFunction::new);
        FUNCTIONS.put("WEEKOFYEAR", WeekOfYearFunction::new);
        FUNCTIONS.put("YEAR", YearFunction::new);
        FUNCTIONS.put("BINARY", BinaryFunction::new);
        FUNCTIONS.put("CAST", CastFunction::new);
        FUNCTIONS.put("COALESCE", CoalesceFunction::new);
        FUNCTIONS.put("CONVERT", ConvertFunction::new);
        FUNCTIONS.put("ISNULL", NvlFunction::new);
        FUNCTIONS.put("NULLIF", NullIfFunction::new);
        FUNCTIONS.put("NVL", NvlFunction::new);
        FUNCTIONS.put("NUMERIC", NumericFunction::new);
        FUNCTIONS.put("ABS", AbsFunction::new);
        FUNCTIONS.put("ACOS", ACosFunction::new);
        FUNCTIONS.put("ACOT", ACotFunction::new);
        FUNCTIONS.put("ASIN", ASinFunction::new);
        FUNCTIONS.put("ATAN", ATanFunction::new);
        FUNCTIONS.put("ATN2", ATN2Function::new);
        FUNCTIONS.put("BIN", BinFunction::new);
        FUNCTIONS.put("CEIL", CeilingFunction::new);
        FUNCTIONS.put("CEILING", CeilingFunction::new);
        FUNCTIONS.put("COS", CosFunction::new);
        FUNCTIONS.put("COSH", CoshFunction::new);
        FUNCTIONS.put("COT", CotFunction::new);
        FUNCTIONS.put("DEGREES", DegreesFunction::new);
        FUNCTIONS.put("EXP", ExpFunction::new);
        FUNCTIONS.put("FLOOR", FloorFunction::new);
        FUNCTIONS.put("HEX", HexFunction::new);
        FUNCTIONS.put("INTEGER", IntegerFunction::new);
        FUNCTIONS.put("ISNUMERIC", IsNumericFunction::new);
        FUNCTIONS.put("LOG10", Log10Function::new);
        FUNCTIONS.put("LOG", LogFunction::new);
        FUNCTIONS.put("PI", PiFunction::new);
        FUNCTIONS.put("POWER", PowerFunction::new);
        FUNCTIONS.put("RADIANS", RadiansFunction::new);
        FUNCTIONS.put("RAND", RandFunction::new);
        FUNCTIONS.put("ROUND", RoundFunction::new);
        FUNCTIONS.put("SIGN", SignFunction::new);
        FUNCTIONS.put("SIN", SinFunction::new);
        FUNCTIONS.put("SQRT", SqrtFunction::new);
        FUNCTIONS.put("SQUARE", SquareFunction::new);
        FUNCTIONS.put("TAN", TanFunction::new);
        FUNCTIONS.put("ASCII", AsciiFunction::new);
        FUNCTIONS.put("BIT_LENGTH", BitLengthFunction::new);
        FUNCTIONS.put("CHAR_LENGTH", CharLengthFunction::new);
        FUNCTIONS.put("CHAR", CharFunction::new);
        FUNCTIONS.put("CHR", ChrFunction::new);
        FUNCTIONS.put("CONCAT", ConcatFunction::new);
        FUNCTIONS.put("CONCAT_WS", ConcatWSFunction::new);
        FUNCTIONS.put("CHARACTER_LENGTH", CharLengthFunction::new);
        FUNCTIONS.put("LENGTH", CharLengthFunction::new);
        FUNCTIONS.put("LEN", CharLengthFunction::new);
        FUNCTIONS.put("INITCAP", InitCapFunction::new);
        FUNCTIONS.put("LEFT", LeftFunction::new);
        FUNCTIONS.put("LOWER", LowerFunction::new);
        FUNCTIONS.put("LPAD", LPadFunction::new);
        FUNCTIONS.put("OCTET_LENGTH", OctetLengthFunction::new);
        FUNCTIONS.put("POSITION", PositionFunction::new);
        FUNCTIONS.put("RPAD", RPadFunction::new);
        FUNCTIONS.put("REPEAT", RepeatFunction::new);
        FUNCTIONS.put("REPLICATE", RepeatFunction::new);
        FUNCTIONS.put("REPLACE", ReplaceFunction::new);
        FUNCTIONS.put("REVERSE", ReverseFunction::new);
        FUNCTIONS.put("RIGHT", RightFunction::new);
        FUNCTIONS.put("SPACE", SpaceFunction::new);
        FUNCTIONS.put("SUBSTRING", SubstringFunction::new);
        FUNCTIONS.put("TRANSLATE", ReplaceFunction::new);
        FUNCTIONS.put("TEXT", TextFunction::new);
        FUNCTIONS.put("TRIM", TrimFunction::new);
        FUNCTIONS.put("UPPER", UpperFunction::new);
        FUNCTIONS.put("VARCHAR", VarcharFunction::new);
        FUNCTIONS.put("CONNECTION_ID", ConnectionIDFunction::new);
        FUNCTIONS.put("CURRENT_SCHEMA", CurrentSchemaFunction::new);
        FUNCTIONS.put("CURRENT_USER", UserFunction::new);
        FUNCTIONS.put("DATABASE", DatabaseFunction::new);
        FUNCTIONS.put("DRIVER_MAJOR_VERSION", DriverMajorVersionFunction::new);
        FUNCTIONS.put("DRIVER_MINOR_VERSION", DriverMinorVersionFunction::new);
        FUNCTIONS.put("DRIVER_NAME", DriverNameFunction::new);
        FUNCTIONS.put("SESSION_USER", UserFunction::new);
        FUNCTIONS.put("SYSTEM_USER", UserFunction::new);
        FUNCTIONS.put("USER", UserFunction::new);
        FUNCTIONS.put("VERSION", VersionFunction::new);
        FUNCTIONS.put("VERSION_NUMBER", VersionNumberFunction::new);
        FUNCTIONS.put("AVG", AvgFunction::new);
        FUNCTIONS.put("COUNT", CountFunction::new);
        FUNCTIONS.put("MAX", MaxFunction::new);
        FUNCTIONS.put("MIN", MinFunction::new);
        FUNCTIONS.put("SUM", SumFunction::new);
        FUNCTION_ALIAS = FUNCTIONS.entrySet().stream().filter(e -> ((AbstractFunction)((Supplier)e.getValue()).get()).isAllowAlias()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

