/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.FunctionType;
import com.googlecode.paradox.parser.nodes.AsteriskNode;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AbstractFunction {
    public static final int IN = 1;
    public static final int RESULT = 5;

    public abstract FunctionType getType();

    public abstract String getRemarks();

    public abstract Column[] getColumns();

    public ParadoxType getFieldType() {
        return Stream.of(this.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getType).findFirst().orElse(ParadoxType.NULL);
    }

    public int getParameterCount() {
        return (int)Stream.of(this.getColumns()).filter(c -> c.getColumnType() == 1).count();
    }

    public boolean isVariableParameters() {
        return false;
    }

    public boolean isGrouping() {
        return false;
    }

    public abstract Object execute(ConnectionInfo var1, Object[] var2, ParadoxType[] var3, FieldNode[] var4) throws SQLException;

    public boolean isAllowAlias() {
        return false;
    }

    public int getMaxParameterCount() {
        return 0;
    }

    public void validate(List<SQLNode> parameters) throws ParadoxSyntaxErrorException {
        for (SQLNode node : parameters) {
            if (!(node instanceof AsteriskNode)) continue;
            throw new ParadoxSyntaxErrorException(SyntaxError.ASTERISK_IN_FUNCTION, node.getPosition());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(this.getClass());
    }

    public boolean isDeterministic() {
        return true;
    }

    public String definition() {
        return null;
    }
}

