/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.exceptions;

public enum SyntaxError {
    EMPTY_SQL("001", "Empty SQL string"),
    NUMBER_FORMAT("002", "Invalid numeric format"),
    UNEXPECTED_END_OF_STATEMENT("003", "Unexpected end of statement"),
    UNEXPECTED_TOKEN("004", "Unexpected token"),
    EMPTY_COLUMN_LIST("005", "Empty column list"),
    INVALID_SELECT_STATEMENT("006", "Invalid SELECT statement"),
    INVALID_CHAR("007", "Invalid value, expected a single char value"),
    EMPTY_TABLE_LIST("008", "Empty table list"),
    EMPTY_CONDITIONAL_LIST("009", "Where without any conditions"),
    ASTERISK_WITHOUT_TABLE("010", "Asterisk without table is not supported"),
    FUNCTION_NOT_FOUND("011", "Function %s not found"),
    INVALID_PARAMETER_COUNT("012", "Invalid function parameter count, expected %s"),
    INVALID_PARAMETER_COUNT_MINIMUM("013", "Invalid function parameter count, expected at last %s"),
    INVALID_PARAMETER_COUNT_MAXIMUM("014", "Invalid function parameter count, got %s expected at maximum %s"),
    ASTERISK_IN_FUNCTION("015", "Asterisk not supported in this type of function"),
    INCONSISTENT_DATA_TYPE("016", "Inconsistent data types: expected %s got %s"),
    INVALID_PARAMETER_VALUE("017", "Invalid parameter value: %s"),
    INCONSISTENT_PARAMETER_LIST("018", "Inconsistent parameter list size"),
    UNTERMINATED_STRING("019", "Unterminated character sequence"),
    INVALID_AGGREGATE_FUNCTION("020", "Invalid use of aggregate function: %s"),
    NOT_GROUP_BY("021", "Not a group by expression"),
    ORDER_BY_NOT_IN_GROUP_BY("022", "Order by columns must be an aggregate or to be in group by expression");

    private final String code;
    private final String description;

    private SyntaxError(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCode() {
        return this.code;
    }
}

