/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.exceptions;

import com.googlecode.paradox.exceptions.ExceptionUtils;
import com.googlecode.paradox.parser.ScannerPosition;
import java.sql.SQLFeatureNotSupportedException;

public class ParadoxNotSupportedException
extends SQLFeatureNotSupportedException {
    private static final String BASE_CODE = "0A";
    private static final String SQL_STATE = "0A000";

    public ParadoxNotSupportedException(Error error) {
        super(ExceptionUtils.message(error.description), SQL_STATE, Integer.parseInt(10 + error.code));
    }

    public ParadoxNotSupportedException(Error error, ScannerPosition position) {
        super(ExceptionUtils.message(error.description, position), SQL_STATE, Integer.parseInt(BASE_CODE + error.code));
    }

    public static enum Error {
        OPERATION_NOT_SUPPORTED("001", "Operation not supported."),
        CATALOG_CHANGE("002", "Change catalog is not supported"),
        USE_BATCH_OPERATION("003", "Use batch for more than one statement"),
        CANCEL_NOT_SUPPORTED("005", "Cancel operation in this type of statement is not supported.");

        private final String code;
        private final String description;

        private Error(String code, String description) {
            this.code = code;
            this.description = description;
        }
    }
}

