/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.exceptions;

import com.googlecode.paradox.exceptions.ExceptionUtils;
import com.googlecode.paradox.parser.ScannerPosition;
import java.sql.SQLDataException;

public class ParadoxException
extends SQLDataException {
    private static final String BASE_CODE = "01";
    private static final String SQL_STATE = "01000";

    public ParadoxException(Error error) {
        super(ExceptionUtils.message(error.description), SQL_STATE, Integer.parseInt(BASE_CODE + error.code));
    }

    public ParadoxException(Error error, Object ... parameter) {
        super(ExceptionUtils.message(error.description, parameter), SQL_STATE, Integer.parseInt(BASE_CODE + error.code));
    }

    public ParadoxException(Error error, ScannerPosition position, Object ... parameter) {
        super(ExceptionUtils.message(error.description, position, parameter), SQL_STATE, Integer.parseInt(BASE_CODE + error.code));
    }

    public static enum Error {
        INVALID_COLUMN("001", "Invalid column name: %s"),
        USE_NEXT_FIRST("002", "Call ResultSet.next() first"),
        NO_MORE_ROWS("003", "There are no more rows to read"),
        RESULT_SET_CLOSED("004", "The ResultSet is closed"),
        TYPE_NOT_FOUND("005", "Type not found"),
        COLUMN_AMBIGUOUS_DEFINED("006", "Column %s ambiguous defined"),
        INVALID_COLUMN_INDEX("007", "Invalid column index: %s"),
        INVALID_FETCH_DIRECTION("008", "Unsupported fetch direction %s"),
        INVALID_LENGTH_SPECIFIED("009", "Invalid length specified"),
        INVALID_POSITION_SPECIFIED("010", "Invalid position specified"),
        INVALID_CATALOG_NAME("011", "Invalid catalog name"),
        SCHEMA_NOT_FOUND("012", "Schema not found"),
        INVALID_TRANSACTION_LEVEL("013", "Invalid transaction level"),
        TABLE_AMBIGUOUS_DEFINED("015", "Table %s ambiguous defined"),
        OPERATION_CANCELLED("016", "Operation cancelled by the user");

        private final String code;
        private final String description;

        private Error(String code, String description) {
            this.code = code;
            this.description = description;
        }
    }
}

