/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.exceptions;

import com.googlecode.paradox.exceptions.ExceptionUtils;
import java.sql.SQLNonTransientException;

public class ParadoxConnectionException
extends SQLNonTransientException {
    private static final String BASE_CODE = "08";
    private static final String SQL_STATE = "08000";

    public ParadoxConnectionException(Error error) {
        super(ExceptionUtils.message(error.description), SQL_STATE, Integer.parseInt(BASE_CODE + error.code));
    }

    public static enum Error {
        DIRECTORY_NOT_FOUND("001", "Directory not found."),
        INVALID_ROOT_DIRECTORY("002", "Can not use root directory"),
        NOT_CONNECTED("003", "Not connected.");

        private final String code;
        private final String description;

        private Error(String code, String description) {
            this.code = code;
            this.description = description;
        }
    }
}

