/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.exceptions;

public enum DataError {
    BLOB_FILE_NOT_FOUND("001", "Blob file not found for table"),
    TOO_MANY_BLOB_FILES("002", "Too many blob files for table"),
    ERROR_OPENING_BLOB_FILE("003", "Error while opening blob file"),
    FIELD_TYPE_NOT_SUPPORTED("004", "Field type not supported"),
    INVALID_FIELD_SIZE("005", "Invalid field size"),
    ERROR_LOADING_DATA("006", "Error loading data from disk"),
    INVALID_DATE("007", "Invalid date"),
    NO_RESULT_SET_AVAILABLE("008", "ResultSet not available"),
    TABLE_NOT_FOUND("009", "Table %s not found"),
    BLOB_READ_HEAD_BLOCK("010", "Trying to read a head lob data"),
    BLOB_READ_FREE_BLOCK("011", "Trying to read a free lob data"),
    BLOB_INVALID_HEADER("012", "Invalid lob header"),
    BLOB_INVALID_HEADER_TYPE("013", "Invalid lob header type"),
    BLOB_INVALID_DECLARED_SIZE("014", "Invalid lob declared size"),
    BLOB_SINGLE_BLOCK_INVALID_INDEX("015", "Offset points to a single blob block but index field is not 0xFF."),
    INVALID_CONVERSION("016", "Invalid value conversion: %s"),
    INVALID_CATALOG_PATH("017", "Invalid catalog path"),
    INVALID_CATALOG_NAME("018", "Invalid catalog name: %s"),
    UNSUPPORTED_FILE_TYPE("019", "Unsupported file type: %s");

    private final String code;
    private final String description;

    private DataError(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

