/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.filefilters;

import com.googlecode.paradox.utils.Expressions;
import java.io.File;
import java.io.FileFilter;
import java.util.Locale;

public final class TableFilter
implements FileFilter {
    private final String extension;
    private final String tableName;
    private final Locale locale;

    public TableFilter(Locale locale) {
        this(locale, null, "db");
    }

    public TableFilter(Locale locale, String tableName) {
        this(locale, tableName, "db");
    }

    public TableFilter(Locale locale, String tableName, String extension) {
        this.locale = locale;
        this.tableName = tableName;
        this.extension = extension;
    }

    @Override
    public boolean accept(File pathname) {
        String name = pathname.getName();
        if (this.tableName != null) {
            return Expressions.accept(this.locale, name, this.tableName + "." + this.extension, false, '\\') && pathname.isFile();
        }
        return Expressions.accept(this.locale, name, "%." + this.extension, false, '\\') && pathname.isFile();
    }
}

