/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.field;

import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.nio.ByteBuffer;

public final class VarcharField
implements FieldParser {
    @Override
    public boolean match(ParadoxType type) {
        return type == ParadoxType.VARCHAR;
    }

    @Override
    public Object parse(ParadoxTable table, ByteBuffer buffer, Field field) {
        int length;
        ByteBuffer valueString = ByteBuffer.allocate(field.getSize());
        System.arraycopy(buffer.array(), buffer.position(), valueString.array(), 0, field.getSize());
        buffer.position(buffer.position() + field.getSize());
        byte[] value = valueString.array();
        for (length = value.length; length > 0 && value[length - 1] == 0; --length) {
        }
        valueString.flip();
        valueString.limit(length);
        String str = table.getCharset().decode(valueString).toString();
        if (str.isEmpty()) {
            return null;
        }
        return str;
    }
}

