/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.field;

import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public final class TimestampField
implements FieldParser {
    private static final long MILLIS_UNTIL_1970 = 62135683200000L;

    @Override
    public boolean match(ParadoxType type) {
        return type == ParadoxType.TIMESTAMP;
    }

    @Override
    public Object parse(ParadoxTable table, ByteBuffer buffer, Field field) {
        long rawValue = buffer.getLong();
        if (rawValue == 0L) {
            return null;
        }
        rawValue = (rawValue & Long.MIN_VALUE) != 0L ? (rawValue &= Long.MAX_VALUE) : (rawValue ^= 0xFFFFFFFFFFFFFFFFL);
        long value = (long)Double.longBitsToDouble(rawValue);
        return new Timestamp(value - 62135683200000L);
    }
}

