/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.field;

import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class TimeField
implements FieldParser {
    @Override
    public boolean match(ParadoxType type) {
        return type == ParadoxType.TIME;
    }

    @Override
    public Object parse(ParadoxTable table, ByteBuffer buffer, Field field) {
        long timeInMillis = (long)buffer.getInt() & 0xFFFFFFFL;
        if (timeInMillis != 0L) {
            GregorianCalendar calendar = new GregorianCalendar(1, 0, 0);
            ((Calendar)calendar).add(14, (int)timeInMillis);
            return new Time(calendar.getTimeInMillis());
        }
        return null;
    }
}

