/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.field;

import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;

public final class NumberField
implements FieldParser {
    @Override
    public boolean match(ParadoxType type) {
        return type == ParadoxType.CURRENCY || type == ParadoxType.NUMBER;
    }

    @Override
    public Double parse(ParadoxTable table, ByteBuffer buffer, Field field) {
        long value = buffer.getLong();
        value = (value & Long.MIN_VALUE) != 0L ? (value &= Long.MAX_VALUE) : (value ^= 0xFFFFFFFFFFFFFFFFL);
        double v = Double.longBitsToDouble(value);
        if (Double.isNaN(v)) {
            return null;
        }
        if (field.getType() == ParadoxType.CURRENCY) {
            BigDecimal decimal = BigDecimal.valueOf(v);
            v = decimal.setScale(field.getPrecision(), RoundingMode.HALF_UP).doubleValue();
        }
        return v;
    }
}

