/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.field;

import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.nio.ByteBuffer;

public final class BytesField
implements FieldParser {
    @Override
    public boolean match(ParadoxType type) {
        return type == ParadoxType.BYTES;
    }

    @Override
    public Object parse(ParadoxTable table, ByteBuffer buffer, Field field) {
        ByteBuffer bytes = ByteBuffer.allocate(field.getSize());
        boolean allZeroes = true;
        for (int chars = 0; chars < field.getSize(); ++chars) {
            byte value = buffer.get();
            bytes.put(value);
            if (value == 0) continue;
            allZeroes = false;
        }
        if (allZeroes) {
            return null;
        }
        return bytes.array();
    }
}

