/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.field;

import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxField;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public final class BCDField
implements FieldParser {
    public static final int BCD_SIZE = 17;
    public static final int MAX_DIGITS = 32;
    public static final byte SECOND_BYTE = 4;

    private static void removeLeadingZeroes(StringBuilder builder) {
        while (builder.length() > 1 && builder.charAt(0) == '0') {
            builder.deleteCharAt(0);
        }
    }

    @Override
    public boolean match(ParadoxType type) {
        return type == ParadoxType.BCD;
    }

    @Override
    public Object parse(ParadoxTable table, ByteBuffer buffer, Field originalField) {
        boolean negative;
        byte[] valueBuffer = new byte[17];
        System.arraycopy(buffer.array(), buffer.position(), valueBuffer, 0, valueBuffer.length);
        buffer.position(buffer.position() + valueBuffer.length);
        if (valueBuffer[0] == 0) {
            return null;
        }
        boolean bl = negative = (valueBuffer[0] & 0x80) == 0;
        if (negative) {
            int i = 1;
            while (i < valueBuffer.length) {
                int n = i++;
                valueBuffer[n] = (byte)(valueBuffer[n] ^ 0xFF);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < valueBuffer.length; ++i) {
            byte high = (byte)(valueBuffer[i] & 0xF0);
            high = (byte)(high >>> 4);
            high = (byte)(high & 0xF);
            byte low = (byte)(valueBuffer[i] & 0xF);
            sb.append(high);
            sb.append(low);
        }
        ParadoxField field = (ParadoxField)originalField;
        int precision = field.getPrecision();
        if (precision == 32) {
            sb.insert(0, "0.");
        } else {
            sb.insert(sb.length() - precision, '.');
            if (precision == 0) {
                sb.append('0');
            }
            BCDField.removeLeadingZeroes(sb);
        }
        if (negative) {
            sb.insert(0, '-');
        }
        if (table.getConnectionInfo().isBcdRounding()) {
            return Double.valueOf(sb.toString());
        }
        return new BigDecimal(sb.toString());
    }
}

