/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data.field;

import com.googlecode.paradox.data.EncryptedData;
import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.sql.SQLException;

public abstract class AbstractLobField
implements FieldParser {
    public static final int HEAD_SIZE = 3;
    public static final int BLOB_HEADER_SIZE = 9;
    private static final int FREE_BLOCK = 4;
    private static final int SINGLE_BLOCK = 2;
    private static final int SUB_BLOCK = 3;
    private static final int GRAPH_HEADER_SIZE = 17;
    public static final int LEADER_SIZE_PADDING = 10;

    private static ByteBuffer readBlock(FileChannel channel, int size, ParadoxTable table) throws IOException {
        long offset;
        long pos = channel.position();
        int blockSize = (int)((long)size + pos - (offset = pos & 0xFFFFFFFFFFFFFF00L));
        if ((blockSize & 0xFF) > 0) {
            blockSize = (blockSize >> 8) + 1 << 8;
        }
        ByteBuffer buffer = ByteBuffer.allocate(blockSize);
        channel.position(offset);
        channel.read(buffer);
        channel.position(pos + (long)size);
        if (table.isEncrypted()) {
            byte[] b = buffer.array();
            EncryptedData.decryptMBBlock(b, table.getEncryptedData(), blockSize);
        }
        buffer.flip();
        int bufferOffset = (int)(pos - offset);
        if (bufferOffset > 0) {
            buffer.position(bufferOffset);
            buffer = buffer.slice();
            buffer.limit(size);
        } else {
            buffer.limit(size);
        }
        return buffer;
    }

    protected abstract Object getValue(ParadoxTable var1, ByteBuffer var2) throws ParadoxDataException;

    /*
     * Exception decompiling
     */
    @Override
    public Object parse(ParadoxTable table, ByteBuffer buffer, Field field) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object processBlobByBlockType(ParadoxTable table, int headerSize, int size, FileChannel channel, long offset, byte type, long index) throws SQLException, IOException {
        switch (type) {
            case 0: {
                throw new ParadoxDataException(DataError.BLOB_READ_HEAD_BLOCK);
            }
            case 1: {
                throw new ParadoxDataException(DataError.BLOB_READ_FREE_BLOCK);
            }
            case 4: {
                throw new ParadoxDataException(DataError.BLOB_INVALID_HEADER);
            }
            case 2: {
                return this.parseSingleBlock(table, index, size, headerSize, channel);
            }
            case 3: {
                return this.parseSubBlock(table, index, offset, size, headerSize, channel);
            }
        }
        throw new ParadoxDataException(DataError.BLOB_INVALID_HEADER_TYPE);
    }

    private Object parseSubBlock(ParadoxTable table, long index, long offset, int size, int headerSize, FileChannel channel) throws IOException, SQLException {
        channel.position(channel.position() + (long)headerSize);
        channel.position(offset + 12L + index * 5L);
        ByteBuffer head = AbstractLobField.readBlock(channel, 5, table);
        head.order(ByteOrder.LITTLE_ENDIAN);
        int blockOffset = head.get() & 0xFF;
        int dataLength = head.get() & 0xFF;
        head.getShort();
        int modulo = head.get() & 0xFF;
        if (size != (dataLength - 1) * 16 + modulo) {
            throw new ParadoxDataException(DataError.BLOB_INVALID_DECLARED_SIZE);
        }
        channel.position(offset + (long)(blockOffset * 16));
        ByteBuffer blocks = AbstractLobField.readBlock(channel, size, table);
        return this.getValue(table, blocks);
    }

    private Object parseSingleBlock(ParadoxTable table, long index, int size, int headerSize, FileChannel channel) throws SQLException, IOException {
        if (index != 255L) {
            throw new ParadoxDataException(DataError.BLOB_SINGLE_BLOCK_INVALID_INDEX);
        }
        ByteBuffer head = AbstractLobField.readBlock(channel, headerSize - 3, table);
        head.order(ByteOrder.LITTLE_ENDIAN);
        int internalSize = head.getInt();
        if (size != internalSize) {
            throw new ParadoxDataException(DataError.BLOB_INVALID_DECLARED_SIZE);
        }
        ByteBuffer blocks = AbstractLobField.readBlock(channel, size, table);
        return this.getValue(table, blocks);
    }
}

