/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data;

import com.googlecode.paradox.data.FieldParser;
import com.googlecode.paradox.data.field.AutoIncrementField;
import com.googlecode.paradox.data.field.BCDField;
import com.googlecode.paradox.data.field.BlobField;
import com.googlecode.paradox.data.field.BooleanField;
import com.googlecode.paradox.data.field.BytesField;
import com.googlecode.paradox.data.field.DateField;
import com.googlecode.paradox.data.field.IntegerField;
import com.googlecode.paradox.data.field.LongField;
import com.googlecode.paradox.data.field.MemoField;
import com.googlecode.paradox.data.field.NumberField;
import com.googlecode.paradox.data.field.TimeField;
import com.googlecode.paradox.data.field.TimestampField;
import com.googlecode.paradox.data.field.VarcharField;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public final class ParadoxFieldFactory {
    private static final FieldParser[] ALL_PARSES = new FieldParser[]{new AutoIncrementField(), new BooleanField(), new BlobField(), new DateField(), new IntegerField(), new LongField(), new MemoField(), new NumberField(), new TimeField(), new TimestampField(), new VarcharField(), new BCDField(), new BytesField()};

    private ParadoxFieldFactory() {
    }

    public static Object parse(ParadoxTable table, ByteBuffer buffer, Field field) throws SQLException {
        for (FieldParser parser : ALL_PARSES) {
            if (!parser.match(field.getType())) continue;
            return parser.parse(table, buffer, field);
        }
        throw new ParadoxDataException(DataError.FIELD_TYPE_NOT_SUPPORTED);
    }
}

