/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.data.EncryptedData;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.paradox.ParadoxDataFile;
import com.googlecode.paradox.metadata.paradox.ParadoxField;
import com.googlecode.paradox.metadata.paradox.ParadoxIndex;
import com.googlecode.paradox.metadata.paradox.ParadoxPK;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ParadoxData {
    protected static final int MINIMUM_VERSION = 4;
    private static final int CHARSET_DEFAULT = 437;
    private static final Charset CP437 = Charset.forName("cp437");
    private static final Map<Integer, Charset> CHARSET_TABLE = new HashMap<Integer, Charset>();

    protected ParadoxData() {
    }

    protected static void checkDBEncryption(ByteBuffer buffer, ParadoxDataFile dataFile, int blockSize, long blockNumber) {
        if (dataFile.isEncrypted()) {
            byte[] b = buffer.array();
            EncryptedData.decryptDBBlock(b, dataFile.getEncryptedData(), blockSize, blockNumber);
        }
    }

    protected static void parseVersionID(ByteBuffer buffer, ParadoxDataFile dataFile, ConnectionInfo connectionInfo) {
        if (dataFile.getVersionId() > 4) {
            buffer.position(106);
            short cp = buffer.getShort();
            if (dataFile.getCharset() == null) {
                dataFile.setCharset(CHARSET_TABLE.getOrDefault(cp, CP437));
                if (CHARSET_TABLE.get(cp) == null) {
                    connectionInfo.addWarning("Charset " + cp + " not found.");
                }
            }
            buffer.position(120);
        } else {
            buffer.position(88);
            if (dataFile.getCharset() == null) {
                dataFile.setCharset(CHARSET_TABLE.get(437));
            }
        }
    }

    private static ParadoxDataFile newInstance(File file, byte type, ConnectionInfo connectionInfo) throws ParadoxDataException {
        switch (type) {
            case 0: 
            case 2: {
                return new ParadoxTable(file, connectionInfo);
            }
            case 1: {
                return new ParadoxPK(file, connectionInfo);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new ParadoxIndex(file, connectionInfo);
            }
        }
        throw new ParadoxDataException(DataError.UNSUPPORTED_FILE_TYPE, type);
    }

    /*
     * Exception decompiling
     */
    protected static <T extends ParadoxDataFile> T loadHeader(File file, ConnectionInfo connectionInfo) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void fixPositionByVersion(ParadoxDataFile dataFile, ByteBuffer buffer, int fieldsSize) {
        if (dataFile.getVersionId() > 4) {
            if (dataFile.getVersionId() == 12) {
                buffer.position(385 + 6 * fieldsSize);
            } else {
                buffer.position(203 + 6 * fieldsSize);
            }
        } else {
            buffer.position(171 + 6 * fieldsSize);
        }
    }

    private static ParadoxField[] parseTableFields(ParadoxDataFile dataFile, ByteBuffer buffer) {
        ParadoxField[] fields = new ParadoxField[dataFile.getFieldCount()];
        for (int loop = 0; loop < dataFile.getFieldCount(); ++loop) {
            ParadoxField field = new ParadoxField(ParadoxType.valueOfVendor(buffer.get()), loop + 1);
            field.setSize(buffer.get() & 0xFF);
            if (dataFile instanceof Table) {
                field.setTable((Table)((Object)dataFile));
            }
            fields[loop] = field;
        }
        return fields;
    }

    private static void parseFieldsName(ParadoxDataFile dataFile, ByteBuffer buffer, ParadoxField[] fields) {
        ByteBuffer name = ByteBuffer.allocate(261);
        for (int loop = 0; loop < dataFile.getFieldCount(); ++loop) {
            byte c;
            name.clear();
            while ((c = buffer.get()) != 0) {
                name.put(c);
            }
            name.flip();
            fields[loop].setName(dataFile.getCharset().decode(name).toString());
        }
        dataFile.setFields(fields);
    }

    private static void parseTableFieldsOrder(ParadoxDataFile dataFile, ByteBuffer buffer) {
        short[] fieldsOrder = new short[dataFile.getFieldCount()];
        for (int loop = 0; loop < dataFile.getFieldCount(); ++loop) {
            fieldsOrder[loop] = buffer.getShort();
        }
        dataFile.setFieldsOrder(fieldsOrder);
    }

    private static void parseSortID(ByteBuffer buffer, ParadoxDataFile index) {
        byte c;
        ByteBuffer sortOrderID = ByteBuffer.allocate(26);
        while ((c = buffer.get()) != 0) {
            sortOrderID.put(c);
        }
        sortOrderID.flip();
        index.setSortOrderID(index.getCharset().decode(sortOrderID).toString());
    }

    private static void parseIndexName(ByteBuffer buffer, ParadoxDataFile index) {
        byte c;
        ByteBuffer name = ByteBuffer.allocate(26);
        while ((c = buffer.get()) != 0) {
            name.put(c);
        }
        name.flip();
        String tempName = index.getCharset().decode(name).toString();
        if (tempName.length() != 0) {
            index.setName(tempName);
        }
    }

    static {
        CHARSET_TABLE.put(437, CP437);
        CHARSET_TABLE.put(850, Charset.forName("cp850"));
        CHARSET_TABLE.put(852, Charset.forName("cp852"));
        CHARSET_TABLE.put(861, Charset.forName("cp861"));
        CHARSET_TABLE.put(862, Charset.forName("cp862"));
        CHARSET_TABLE.put(863, Charset.forName("cp863"));
        CHARSET_TABLE.put(865, Charset.forName("cp865"));
        CHARSET_TABLE.put(866, Charset.forName("cp866"));
        CHARSET_TABLE.put(867, Charset.forName("cp862"));
        CHARSET_TABLE.put(932, Charset.forName("windows-31j"));
        CHARSET_TABLE.put(936, Charset.forName("cp936"));
        CHARSET_TABLE.put(1251, Charset.forName("cp1251"));
        CHARSET_TABLE.put(1252, Charset.forName("cp1252"));
    }
}

