/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.data;

public final class EncryptedData {
    private static final int BLOCK_DIVISION = 8;
    private static final int SECOND_BYTE = 8;
    private static final int ENCRYPTION_TABLE_SIZE = 256;
    private static final int[] ENCRYPTION_TABLE_A = new int[]{178, 165, 12, 221, 56, 254, 203, 91, 12, 35, 236, 106, 149, 62, 213, 45, 44, 247, 45, 48, 234, 21, 152, 180, 95, 130, 211, 175, 244, 76, 132, 22, 116, 23, 5, 17, 172, 219, 67, 145, 156, 119, 160, 56, 190, 214, 143, 37, 177, 238, 109, 128, 55, 20, 169, 122, 87, 56, 108, 47, 166, 79, 124, 56, 113, 212, 11, 81, 246, 185, 69, 33, 29, 108, 77, 135, 110, 167, 231, 33, 13, 133, 244, 206, 58, 129, 106, 62, 215, 50, 164, 35, 172, 233, 1, 145, 176, 237, 199, 70, 18, 172, 21, 61, 255, 27, 123, 59, 186, 238, 44, 44, 104, 166, 98, 96, 237, 91, 132, 51, 97, 98, 57, 121, 212, 210, 235, 96, 184, 37, 29, 219, 255, 58, 33, 154, 176, 195, 247, 99, 82, 245, 34, 148, 249, 180, 183, 190, 159, 84, 59, 206, 225, 60, 115, 203, 234, 45, 69, 0, 157, 194, 120, 231, 150, 15, 20, 58, 164, 220, 1, 100, 141, 214, 89, 78, 57, 15, 21, 125, 240, 140, 138, 197, 120, 3, 74, 232, 251, 239, 24, 180, 82, 49, 121, 208, 142, 170, 195, 198, 206, 237, 233, 66, 90, 214, 45, 6, 199, 154, 177, 56, 98, 217, 126, 97, 116, 210, 70, 222, 203, 43, 12, 89, 11, 100, 157, 28, 79, 178, 6, 145, 155, 99, 181, 178, 169, 253, 173, 90, 56, 249, 19, 110, 157, 45, 75, 2, 249, 19, 111, 80, 203, 33, 9, 250};
    private static final int[] ENCRYPTION_TABLE_B = new int[]{97, 167, 121, 2, 55, 52, 111, 129, 1, 194, 178, 179, 214, 77, 62, 3, 6, 96, 152, 68, 70, 104, 28, 235, 16, 74, 91, 174, 34, 72, 36, 66, 159, 85, 144, 193, 125, 47, 108, 65, 78, 130, 86, 216, 30, 50, 40, 198, 237, 188, 60, 58, 233, 135, 59, 143, 134, 8, 163, 251, 164, 98, 153, 255, 89, 185, 222, 45, 88, 147, 27, 177, 118, 43, 170, 217, 42, 172, 202, 249, 224, 183, 5, 17, 119, 169, 142, 239, 181, 187, 38, 234, 141, 24, 155, 254, 199, 248, 90, 131, 253, 46, 107, 132, 51, 250, 105, 212, 116, 191, 203, 196, 25, 150, 63, 229, 37, 242, 165, 213, 149, 243, 160, 57, 220, 228, 161, 127, 123, 73, 122, 241, 238, 247, 117, 9, 145, 103, 151, 56, 211, 137, 71, 49, 31, 44, 14, 206, 32, 204, 156, 35, 23, 146, 15, 244, 19, 100, 113, 200, 205, 61, 180, 207, 225, 80, 82, 175, 109, 39, 182, 148, 48, 4, 140, 83, 75, 210, 79, 33, 41, 106, 26, 236, 92, 126, 81, 154, 13, 133, 230, 29, 197, 136, 168, 221, 158, 246, 95, 218, 189, 110, 157, 84, 219, 94, 192, 128, 93, 184, 64, 99, 21, 18, 162, 12, 7, 173, 112, 20, 114, 22, 208, 166, 101, 53, 186, 231, 171, 252, 195, 201, 190, 11, 176, 245, 69, 226, 76, 115, 10, 54, 120, 67, 139, 138, 240, 102, 209, 0, 223, 124, 227, 232, 87, 215};
    private static final int[] ENCRYPTION_TABLE_C = new int[]{249, 8, 3, 15, 173, 82, 16, 216, 57, 135, 240, 233, 215, 188, 146, 154, 24, 83, 213, 156, 219, 212, 221, 152, 93, 112, 182, 70, 22, 191, 44, 144, 148, 179, 28, 151, 30, 116, 90, 169, 46, 180, 76, 73, 145, 67, 101, 37, 172, 143, 45, 104, 5, 225, 241, 4, 139, 123, 51, 54, 50, 161, 14, 114, 210, 39, 31, 243, 19, 236, 20, 142, 29, 129, 25, 176, 238, 13, 40, 178, 165, 186, 166, 175, 203, 33, 42, 254, 68, 64, 98, 26, 184, 208, 205, 198, 17, 0, 61, 211, 157, 224, 247, 137, 21, 106, 181, 102, 38, 168, 201, 6, 218, 158, 220, 239, 108, 134, 72, 84, 242, 2, 130, 128, 251, 36, 185, 127, 207, 7, 41, 99, 103, 189, 56, 53, 193, 141, 245, 244, 174, 92, 86, 55, 34, 136, 153, 69, 171, 120, 113, 138, 18, 62, 187, 94, 150, 202, 196, 32, 122, 126, 214, 58, 60, 118, 223, 1, 194, 85, 74, 228, 77, 217, 27, 167, 234, 71, 10, 11, 162, 88, 170, 81, 209, 65, 226, 89, 49, 200, 232, 109, 206, 35, 9, 230, 111, 192, 47, 96, 159, 231, 78, 110, 149, 160, 147, 163, 222, 248, 177, 140, 107, 119, 12, 255, 43, 75, 199, 204, 124, 195, 66, 250, 80, 164, 237, 252, 125, 115, 190, 227, 253, 52, 91, 23, 183, 48, 132, 87, 246, 131, 117, 121, 155, 235, 197, 133, 97, 79, 105, 59, 229, 100, 95, 63};

    private EncryptedData() {
    }

    private static void decryptChunk(byte[] src, int offset, int a, int b, int c, int d) {
        byte[] tmp = new byte[256];
        for (int x = 0; x < tmp.length; ++x) {
            int y = ENCRYPTION_TABLE_C[x] - (d & 0xFF) & 0xFF;
            tmp[x] = (byte)(src[y + offset] ^ ENCRYPTION_TABLE_A[x + (a & 0xFF) & 0xFF] ^ ENCRYPTION_TABLE_B[y + (b & 0xFF) & 0xFF] ^ ENCRYPTION_TABLE_C[y + (c & 0xFF) & 0xFF]);
        }
        System.arraycopy(tmp, 0, src, offset, tmp.length);
    }

    public static void decryptDBBlock(byte[] src, long encryption, int blockSize, long blockNo) {
        byte a = (byte)(encryption & 0xFFL);
        byte b = (byte)(encryption >> 8 & 0xFFL);
        blockSize >>= 8;
        for (int chunk = 0; chunk < blockSize; ++chunk) {
            EncryptedData.decryptChunk(src, chunk << 8, a, b, chunk, (int)blockNo);
        }
    }

    public static void decryptMBBlock(byte[] src, long encryption, int blockSize) {
        byte a = (byte)(encryption & 0xFFL);
        byte b = (byte)(encryption >> 8 & 0xFFL);
        blockSize >>= 8;
        for (int chunk = 0; chunk < blockSize; ++chunk) {
            EncryptedData.decryptChunk(src, chunk << 8, a, b, a + 1, b + 1);
        }
    }
}

