/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.ParadoxConnection;
import com.googlecode.paradox.ParadoxResultSet;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.InternalException;
import com.googlecode.paradox.exceptions.ParadoxConnectionException;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.exceptions.ParadoxNotSupportedException;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.planner.context.Context;
import com.googlecode.paradox.planner.context.SelectContext;
import com.googlecode.paradox.planner.plan.Plan;
import com.googlecode.paradox.planner.plan.SelectPlan;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.utils.Utils;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

class ParadoxStatement
implements Statement {
    protected final List<Plan<?, ?>> statements = new ArrayList();
    protected final List<ResultSet> resultSets = new ArrayList<ResultSet>();
    protected final int resultSetConcurrency;
    protected final int resultSetType;
    private final int resultSetHoldability;
    private final HashSet<Context> activeExecutions = new HashSet();
    protected final WeakReference<ParadoxConnection> connection;
    protected int autoGeneratedKeys;
    protected int resultSetIndex = -1;
    protected boolean closeOnCompletion;
    protected boolean closed;
    protected int maxRows;
    private int fetchDirection = 1000;
    private int fetchSize = 10;
    private int maxFieldSize = 255;
    private boolean poolable;
    private int queryTimeout;
    protected ConnectionInfo connectionInfo;

    ParadoxStatement(ParadoxConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = new WeakReference<ParadoxConnection>(connection);
        this.connectionInfo = connection.getConnectionInfo();
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.autoGeneratedKeys = 2;
    }

    protected int[] executeStatements() throws SQLException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Plan<?, ?> plan : this.statements) {
            try {
                ret.addAll(this.executeStatement(plan, null, null));
            }
            catch (InternalException e) {
                throw e.getCause();
            }
        }
        return ret.stream().mapToInt(Integer::intValue).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> executeStatement(Plan<?, ?> plan, Object[] params, ParadoxType[] types) throws SQLException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (plan instanceof SelectPlan) {
            SelectPlan selectPlan = (SelectPlan)plan;
            SelectContext context = selectPlan.createContext(this.connectionInfo, params, types);
            context.setMaxRows(this.maxRows);
            this.activeExecutions.add(context);
            try {
                List<Object[]> values = selectPlan.execute(context);
                ParadoxResultSet resultSet = new ParadoxResultSet(this.connectionInfo, this, values, selectPlan.getColumns());
                resultSet.setFetchDirection(1000);
                resultSet.setType(this.resultSetType);
                resultSet.setConcurrency(this.resultSetConcurrency);
                ret.add(-2);
                this.resultSets.add(resultSet);
            }
            finally {
                this.activeExecutions.remove(context);
            }
        }
        return ret;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.connection == null || this.connection.get() == null) {
            throw new ParadoxConnectionException(ParadoxConnectionException.Error.NOT_CONNECTED);
        }
        this.statements.add(((ParadoxConnection)Objects.requireNonNull(this.connection.get())).createPlan(sql));
    }

    @Override
    public void cancel() throws SQLFeatureNotSupportedException {
        for (Context node : this.activeExecutions) {
            node.cancel();
        }
    }

    @Override
    public void clearBatch() {
        this.statements.clear();
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void close() throws SQLException {
        for (ResultSet rs : this.resultSets) {
            rs.close();
        }
        this.resultSets.clear();
        this.statements.clear();
        this.closed = true;
        this.connectionInfo = null;
    }

    @Override
    public void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.connection == null || this.connection.get() == null) {
            throw new ParadoxConnectionException(ParadoxConnectionException.Error.NOT_CONNECTED);
        }
        this.statements.add(((ParadoxConnection)Objects.requireNonNull(this.connection.get())).createPlan(sql));
        this.executeStatements();
        return this.getMoreResults();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeStatements();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.connection == null || this.connection.get() == null) {
            throw new ParadoxConnectionException(ParadoxConnectionException.Error.NOT_CONNECTED);
        }
        this.statements.add(((ParadoxConnection)Objects.requireNonNull(this.connection.get())).createPlan(sql));
        this.executeStatements();
        if (this.getMoreResults()) {
            return this.getResultSet();
        }
        throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_SELECT_STATEMENT);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) {
        return 0;
    }

    @Override
    public Connection getConnection() {
        if (this.connection != null) {
            return (Connection)this.connection.get();
        }
        return null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getFetchDirection();
        }
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            resultSet.setFetchDirection(direction);
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getFetchSize();
        }
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            resultSet.setFetchSize(fetchSize);
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return new ParadoxResultSet(this.connectionInfo, this, new ArrayList(), new ArrayList<Column>());
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max > 255) {
            throw new ParadoxDataException(DataError.INVALID_FIELD_SIZE);
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) {
        this.maxRows = max;
    }

    @Override
    public boolean getMoreResults() {
        if (this.resultSetIndex < this.resultSets.size()) {
            ++this.resultSetIndex;
        }
        return this.resultSetIndex < this.resultSets.size();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        switch (current) {
            case 1: {
                ResultSet currentResult = this.getResultSet();
                if (currentResult == null) break;
                currentResult.close();
                break;
            }
            case 3: {
                for (ResultSet rs : this.resultSets) {
                    rs.close();
                }
                break;
            }
        }
        return this.getMoreResults();
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    @Override
    public ResultSet getResultSet() {
        if (this.resultSetIndex != -1 && this.resultSetIndex < this.resultSets.size()) {
            return this.resultSets.get(this.resultSetIndex);
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getConcurrency();
        }
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Override
    public int getResultSetType() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getType();
        }
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() {
        return -1;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean canPool) {
        this.poolable = canPool;
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return Utils.isWrapperFor(this, iFace);
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return Utils.unwrap(this, iFace);
    }

    @Override
    public void setCursorName(String name) throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }
}

