/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox;

import com.googlecode.paradox.ParadoxConnection;
import com.googlecode.paradox.ParadoxStatement;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.InternalException;
import com.googlecode.paradox.exceptions.ParadoxConnectionException;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.exceptions.ParadoxNotSupportedException;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.planner.plan.Plan;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import com.googlecode.paradox.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;

class ParadoxPreparedStatement
extends ParadoxStatement
implements PreparedStatement {
    protected final List<Object[]> executions = new ArrayList<Object[]>();
    protected final List<ParadoxType[]> executionTypes = new ArrayList<ParadoxType[]>();
    private final Object[] currentParameterValues;
    private final ParadoxType[] currentParameterTypes;

    ParadoxPreparedStatement(ParadoxConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statements.add(connection.createPlan(sql));
        if (this.statements.isEmpty()) {
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_SQL);
        }
        if (this.statements.size() > 1) {
            throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.USE_BATCH_OPERATION);
        }
        this.currentParameterValues = new Object[((Plan)this.statements.get(0)).getParameterCount()];
        this.currentParameterTypes = new ParadoxType[((Plan)this.statements.get(0)).getParameterCount()];
    }

    public void setAutoGeneratedKeys(int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    @Override
    protected int[] executeStatements() throws SQLException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Plan plan : this.statements) {
            for (int i = 0; i < this.executions.size(); ++i) {
                Object[] params = this.executions.get(i);
                ParadoxType[] types = this.executionTypes.get(i);
                try {
                    ret.addAll(this.executeStatement(plan, params, types));
                    continue;
                }
                catch (InternalException e) {
                    throw e.getCause();
                }
            }
        }
        return ret.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executions.add(this.currentParameterValues);
        this.executionTypes.add(this.currentParameterTypes);
        this.executeStatements();
        this.resultSetIndex = 0;
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = null;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.valueOf(sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.BOOLEAN;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.INTEGER;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.INTEGER;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.INTEGER;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.NUMBER;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = Float.valueOf(x);
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.NUMBER;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.NUMBER;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.NUMBER;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.VARCHAR;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.BLOB;
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.DATE;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.TIME;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.TIMESTAMP;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.MEMO;
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void clearParameters() {
        Arrays.fill(this.currentParameterValues, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int type) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.valueOf(type);
    }

    @Override
    public void setObject(int parameterIndex, Object instance) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = instance;
        this.currentParameterTypes[parameterIndex - 1] = instance != null ? ParadoxType.valueOf(instance.getClass()) : ParadoxType.NULL;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeQuery() != null;
    }

    @Override
    public void addBatch() {
        this.executions.add(this.currentParameterValues);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.BLOB;
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = ParadoxType.MEMO;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet current = this.getResultSet();
        return current.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int sqlType, int scaleOrLength) throws SQLException {
        this.checkIndex(parameterIndex);
        Object value = x;
        if (x instanceof InputStream) {
            value = ValuesConverter.getBytes((InputStream)x, scaleOrLength);
        } else if (x instanceof Reader) {
            try {
                char[] chars = new char[scaleOrLength];
                if (((Reader)x).read(chars) != scaleOrLength) {
                    throw new ParadoxDataException(DataError.INVALID_CONVERSION, x);
                }
                value = new String(chars);
            }
            catch (IOException e) {
                throw new ParadoxDataException(DataError.INVALID_CONVERSION, e, x);
            }
        } else if (sqlType == 2 || sqlType == 3) {
            value = ValuesConverter.getBigDecimal(x, this.connectionInfo).setScale(scaleOrLength, RoundingMode.DOWN);
        }
        this.currentParameterValues[parameterIndex - 1] = value;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.valueOf(sqlType);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.currentParameterValues[parameterIndex - 1] = x;
        this.currentParameterTypes[parameterIndex - 1] = ParadoxType.BLOB;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.connection == null || this.connection.get() == null) {
            throw new ParadoxConnectionException(ParadoxConnectionException.Error.NOT_CONNECTED);
        }
        Plan<?, ?> plan = ((ParadoxConnection)Objects.requireNonNull(this.connection.get())).createPlan(sql);
        if (plan.getParameterCount() != this.currentParameterValues.length) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INCONSISTENT_PARAMETER_LIST);
        }
        this.statements.add(plan);
    }

    @Override
    public void clearBatch() {
        this.executions.clear();
        while (this.statements.size() > 1) {
            this.statements.remove(1);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return Utils.unwrap(this, iFace);
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return Utils.isWrapperFor(this, iFace);
    }

    private void checkIndex(int index) throws ParadoxException {
        if (index < 1 || index > this.currentParameterValues.length) {
            throw new ParadoxException(ParadoxException.Error.INVALID_COLUMN_INDEX, Integer.toString(index), null);
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.executions.clear();
        Arrays.fill(this.currentParameterValues, null);
    }
}

