/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.ParadoxPreparedStatement;
import com.googlecode.paradox.ParadoxStatement;
import com.googlecode.paradox.exceptions.ParadoxConnectionException;
import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.exceptions.ParadoxNotSupportedException;
import com.googlecode.paradox.metadata.ParadoxDatabaseMetaData;
import com.googlecode.paradox.metadata.schema.DirectorySchema;
import com.googlecode.paradox.parser.SQLParser;
import com.googlecode.paradox.planner.Planner;
import com.googlecode.paradox.planner.plan.Plan;
import com.googlecode.paradox.rowset.ParadoxBlob;
import com.googlecode.paradox.rowset.ParadoxClob;
import com.googlecode.paradox.utils.Utils;
import java.io.File;
import java.lang.ref.SoftReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public final class ParadoxConnection
implements Connection {
    private final List<ParadoxStatement> statements = new ArrayList<ParadoxStatement>();
    private boolean autocommit = true;
    private boolean closed;
    private int networkTimeout;
    private boolean readonly = true;
    private int transactionIsolation = 0;
    private Map<String, Class<?>> typeMap;
    private final ConnectionInfo connectionInfo;
    private static final HashMap<String, LinkedHashMap<String, SoftReference<Plan<?, ?>>>> STATEMENT_CACHE = new HashMap();

    public ParadoxConnection(File dir, String url, Properties info) throws SQLException {
        if (!dir.exists() && !dir.isDirectory()) {
            throw new ParadoxConnectionException(ParadoxConnectionException.Error.DIRECTORY_NOT_FOUND);
        }
        if (dir.getParent() == null) {
            throw new ParadoxConnectionException(ParadoxConnectionException.Error.INVALID_ROOT_DIRECTORY);
        }
        this.connectionInfo = new ConnectionInfo(url);
        this.connectionInfo.setProperties(info);
        this.connectionInfo.setCurrentCatalog(dir.getParentFile());
        this.connectionInfo.setCurrentSchema(new DirectorySchema(dir));
    }

    public Plan<?, ?> createPlan(String sql) throws SQLException {
        Plan<?, ?> plan;
        LinkedHashMap cache = STATEMENT_CACHE.computeIfAbsent(this.connectionInfo.getUrl(), k -> new LinkedHashMap(127, 0.75f, true));
        SoftReference cached = (SoftReference)cache.get(sql);
        if (cached == null || cached.get() == null) {
            SQLParser parser = new SQLParser(sql);
            plan = Planner.create(this.connectionInfo, parser.parse());
            cache.put(sql, new SoftReference(plan));
        } else {
            plan = (Plan<?, ?>)cached.get();
        }
        return plan;
    }

    @Override
    public void abort(Executor executor) {
        executor.execute(this::abort);
    }

    private void abort() {
        for (ParadoxStatement stmt : this.statements) {
            try {
                stmt.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        this.statements.clear();
        this.closed = true;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void close() throws SQLException {
        for (Statement statement : this.statements) {
            statement.close();
        }
        this.statements.clear();
        this.closed = true;
    }

    @Override
    public void commit() throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public Blob createBlob() {
        return new ParadoxBlob(new byte[0]);
    }

    @Override
    public Clob createClob() {
        return new ParadoxClob("");
    }

    @Override
    public NClob createNClob() throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public Statement createStatement() {
        return this.createStatement(1004, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return this.createStatement(resultSetType, resultSetConcurrency, this.connectionInfo.getHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        ParadoxStatement stmt = new ParadoxStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statements.add(stmt);
        return stmt;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public boolean getAutoCommit() {
        return this.autocommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.autocommit = autoCommit;
    }

    @Override
    public String getCatalog() {
        return this.connectionInfo.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connectionInfo.setCatalog(catalog);
    }

    @Override
    public Properties getClientInfo() {
        return this.connectionInfo.getProperties();
    }

    @Override
    public void setClientInfo(Properties clientInfo) throws SQLClientInfoException {
        this.connectionInfo.setProperties(clientInfo);
    }

    @Override
    public String getClientInfo(String name) {
        return this.connectionInfo.getProperty(name);
    }

    @Override
    public int getHoldability() {
        return this.connectionInfo.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) {
        this.connectionInfo.setHoldability(holdability);
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new ParadoxDatabaseMetaData(this);
    }

    @Override
    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Override
    public String getSchema() {
        return this.connectionInfo.getCurrentSchema().name();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connectionInfo.setCurrentSchema(schema);
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (0 != level) {
            throw new ParadoxException(ParadoxException.Error.INVALID_TRANSACTION_LEVEL);
        }
        this.transactionIsolation = level;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) {
        this.typeMap = typeMap;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.connectionInfo.getWarning();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
    }

    @Override
    public boolean isValid(int timeout) {
        return !this.closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return Utils.isWrapperFor(this, iFace);
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.connectionInfo.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement statement = this.prepareStatement(sql, 1004, 1007, this.connectionInfo.getHoldability());
        ((ParadoxPreparedStatement)statement).setAutoGeneratedKeys(autoGeneratedKeys);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ParadoxPreparedStatement statement = new ParadoxPreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.connectionInfo.getHoldability());
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void rollback() throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void rollback(Savepoint savepoint) throws ParadoxNotSupportedException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connectionInfo.put(name, value);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) {
        this.networkTimeout = milliseconds;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return Utils.unwrap(this, iFace);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

