/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.ParadoxConnection;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Driver
implements java.sql.Driver {
    private static final Logger LOGGER = Logger.getLogger(Driver.class.getName());

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith("jdbc:paradox:");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            String dirName = url.substring("jdbc:paradox:".length());
            return new ParadoxConnection(new File(dirName), url, info);
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 6;
    }

    @Override
    public Logger getParentLogger() {
        return LOGGER;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return ConnectionInfo.getMetaData(info);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            Driver driverInst = new Driver();
            DriverManager.registerDriver(driverInst);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

