/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox;

import com.googlecode.paradox.data.filefilters.DirectoryFilter;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.exceptions.ParadoxNotSupportedException;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.schema.DirectorySchema;
import com.googlecode.paradox.metadata.schema.SystemSchema;
import com.googlecode.paradox.utils.Expressions;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.ClientInfoStatus;
import java.sql.DriverPropertyInfo;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ConnectionInfo {
    public static final String CHARSET_KEY = "charset";
    public static final String LOCALE_KEY = "locale";
    public static final String BCD_ROUNDING_KEY = "bcd_rounding";
    public static final String USER_KEY = "user";
    public static final String TIMEZONE_KEY = "timezone";
    public static final String ENABLE_CATALOG_KEY = "enable_catalogs";
    public static final Charset DEFAULT_CHARSET = null;
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final boolean DEFAULT_BCD_ROUND = true;
    public static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    public static final boolean DEFAULT_ENABLE_CATALOG = false;
    public static final String DEFAULT_USER = "sys";
    public static final String INFORMATION_SCHEMA = "information_schema";
    private final String url;
    private Charset charset = DEFAULT_CHARSET;
    private Locale locale = DEFAULT_LOCALE;
    private TimeZone timeZone = DEFAULT_TIMEZONE;
    private boolean bcdRounding = true;
    private Schema currentSchema;
    private File currentCatalog;
    private int holdability = 2;
    private boolean enableCatalogChange = false;
    private String user = "sys";
    private SQLWarning warning;

    public ConnectionInfo(String url) {
        this.url = url;
    }

    public List<Schema> getSchemas(String catalog, String schemaPattern) throws SQLException {
        File[] catalogs = null;
        if (!this.enableCatalogChange) {
            if (catalog == null || this.getCatalog().equalsIgnoreCase(catalog)) {
                catalogs = new File[]{this.currentCatalog};
            }
        } else {
            File parent = this.currentCatalog.getParentFile();
            if (!parent.isDirectory()) {
                throw new ParadoxDataException(DataError.INVALID_CATALOG_PATH);
            }
            catalogs = parent.listFiles(new DirectoryFilter(this.locale, catalog));
        }
        ArrayList<Schema> ret = new ArrayList<Schema>();
        if (catalogs != null) {
            for (File catalogFile : catalogs) {
                File[] schemas = catalogFile.listFiles(new DirectoryFilter(this.locale, schemaPattern));
                if (schemas != null) {
                    ret.addAll(Stream.of(schemas).filter(Objects::nonNull).map(DirectorySchema::new).collect(Collectors.toList()));
                }
                if (schemaPattern != null && !Expressions.accept(this.locale, INFORMATION_SCHEMA, schemaPattern, false, '\\')) continue;
                ret.add(new SystemSchema(this, catalogFile.getName()));
            }
        }
        ret.sort(Comparator.comparing(Schema::name));
        return ret;
    }

    public Schema getSchema(String catalog, String schemaName) throws SQLException {
        File[] catalogs = null;
        if (!this.enableCatalogChange) {
            if (catalog == null || this.getCatalog().equalsIgnoreCase(catalog)) {
                catalogs = new File[]{this.currentCatalog};
            }
        } else {
            File parent = this.currentCatalog.getParentFile();
            if (!parent.isDirectory()) {
                throw new ParadoxDataException(DataError.INVALID_CATALOG_PATH);
            }
            catalogs = parent.listFiles(new DirectoryFilter(this.locale, catalog));
        }
        if (catalogs == null || catalogs.length != 1) {
            throw new ParadoxDataException(DataError.INVALID_CATALOG_NAME);
        }
        if (INFORMATION_SCHEMA.equalsIgnoreCase(schemaName)) {
            return new SystemSchema(this, catalogs[0].getName());
        }
        for (File catalogFile : catalogs) {
            File[] schemas = catalogFile.listFiles(new DirectoryFilter(this.locale, schemaName));
            if (schemas == null || schemas.length != 1) continue;
            return new DirectorySchema(schemas[0]);
        }
        throw new ParadoxException(ParadoxException.Error.SCHEMA_NOT_FOUND);
    }

    private static String getPropertyValue(String key, String defaultValue, Properties info) {
        String ret = null;
        if (info != null) {
            ret = info.getProperty(key);
        }
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static DriverPropertyInfo[] getMetaData(Properties info) {
        String charsetValue = ConnectionInfo.getPropertyValue(CHARSET_KEY, null, info);
        String localeValue = ConnectionInfo.getPropertyValue(LOCALE_KEY, DEFAULT_LOCALE.toLanguageTag(), info);
        String bcdRounding = ConnectionInfo.getPropertyValue(BCD_ROUNDING_KEY, String.valueOf(true), info);
        String timeZoneId = ConnectionInfo.getPropertyValue(TIMEZONE_KEY, DEFAULT_TIMEZONE.getID(), info);
        String enableCatalog = ConnectionInfo.getPropertyValue(ENABLE_CATALOG_KEY, String.valueOf(false), info);
        String user = ConnectionInfo.getPropertyValue(USER_KEY, DEFAULT_USER, info);
        DriverPropertyInfo bcdRoundingProp = new DriverPropertyInfo(BCD_ROUNDING_KEY, bcdRounding);
        bcdRoundingProp.choices = new String[]{"true", "false"};
        bcdRoundingProp.required = false;
        bcdRoundingProp.description = "Use BCD double rounding (true to use rounding, the original used by Paradox).";
        DriverPropertyInfo enableCatalogProp = new DriverPropertyInfo(ENABLE_CATALOG_KEY, enableCatalog);
        enableCatalogProp.choices = new String[]{"true", "false"};
        enableCatalogProp.required = false;
        enableCatalogProp.description = "Enable catalog info.";
        DriverPropertyInfo charset = new DriverPropertyInfo(CHARSET_KEY, charsetValue);
        charset.choices = Charset.availableCharsets().keySet().toArray(new String[0]);
        charset.required = false;
        charset.description = "Table charset (empty value to use the charset defined in table).";
        Arrays.sort(charset.choices);
        DriverPropertyInfo localeProp = new DriverPropertyInfo(LOCALE_KEY, localeValue);
        localeProp.choices = (String[])Arrays.stream(Locale.getAvailableLocales()).map(Locale::toLanguageTag).toArray(String[]::new);
        localeProp.required = false;
        localeProp.description = "The locale to use internally by the driver.";
        Arrays.sort(localeProp.choices);
        DriverPropertyInfo timeZoneProp = new DriverPropertyInfo(TIMEZONE_KEY, timeZoneId);
        timeZoneProp.choices = TimeZone.getAvailableIDs();
        timeZoneProp.required = false;
        timeZoneProp.description = "Time zone ID for use in date and time functions.";
        Arrays.sort(timeZoneProp.choices);
        DriverPropertyInfo userProp = new DriverPropertyInfo(USER_KEY, user);
        userProp.required = false;
        userProp.description = "User to use in connection.";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", "");
        passwordProp.required = false;
        passwordProp.description = "Password to use in connection.";
        return new DriverPropertyInfo[]{bcdRoundingProp, charset, enableCatalogProp, localeProp, passwordProp, timeZoneProp, userProp};
    }

    public String getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    private <T> T getProperty(String name, String value, Map<String, ClientInfoStatus> errors, T defaultValue, Function<String, T> converter) {
        try {
            if (value != null && !value.trim().isEmpty()) {
                return converter.apply(value);
            }
            return defaultValue;
        }
        catch (Exception e) {
            this.addWarning(e);
            errors.put(name, ClientInfoStatus.REASON_VALUE_INVALID);
            return defaultValue;
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put(BCD_ROUNDING_KEY, Boolean.toString(this.bcdRounding));
        if (this.charset != null) {
            properties.put(CHARSET_KEY, this.charset.displayName());
        }
        properties.put((Object)false, Boolean.toString(this.enableCatalogChange));
        properties.put(LOCALE_KEY, this.locale.toLanguageTag());
        properties.put(DEFAULT_TIMEZONE, this.timeZone.getID());
        properties.put(USER_KEY, this.user);
        return properties;
    }

    public void setProperties(Properties info) throws SQLClientInfoException {
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = null;
            if (entry.getValue() != null) {
                value = String.valueOf(entry.getValue());
            }
            this.put(key, value);
        }
    }

    public void put(String name, String value) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> errors = new HashMap<String, ClientInfoStatus>();
        if (name == null) {
            throw new SQLClientInfoException("Property name can not be null.", errors);
        }
        switch (name) {
            case "bcd_rounding": {
                this.bcdRounding = this.getProperty(name, value, errors, true, Boolean::parseBoolean);
                break;
            }
            case "charset": {
                this.charset = this.getProperty(name, value, errors, DEFAULT_CHARSET, Charset::forName);
                break;
            }
            case "enable_catalogs": {
                this.enableCatalogChange = this.getProperty(name, value, errors, false, Boolean::parseBoolean);
                break;
            }
            case "locale": {
                this.locale = this.getProperty(name, value, errors, DEFAULT_LOCALE, Locale::forLanguageTag);
                break;
            }
            case "timezone": {
                this.timeZone = this.getProperty(name, value, errors, DEFAULT_TIMEZONE, TimeZone::getTimeZone);
                break;
            }
            case "user": {
                this.user = this.getProperty(name, value, errors, USER_KEY, String::valueOf);
                break;
            }
            case "password": {
                break;
            }
            default: {
                errors.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            }
        }
        if (!errors.isEmpty()) {
            throw new SQLClientInfoException(errors);
        }
    }

    public void setCatalog(String name) throws SQLException {
        if (!this.enableCatalogChange) {
            if (this.getCatalog().equalsIgnoreCase(name)) {
                return;
            }
            throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.CATALOG_CHANGE);
        }
        File parent = this.currentCatalog.getParentFile();
        if (!parent.isDirectory()) {
            throw new ParadoxDataException(DataError.INVALID_CATALOG_PATH);
        }
        File newCatalog = new File(parent, name);
        if (!newCatalog.isDirectory()) {
            throw new ParadoxDataException(DataError.INVALID_CATALOG_NAME, name);
        }
        this.currentCatalog = newCatalog;
        this.currentSchema = new SystemSchema(this, newCatalog.getName());
    }

    public List<String> listCatalogs() throws ParadoxDataException {
        ArrayList<String> catalogs = new ArrayList<String>();
        if (this.enableCatalogChange && this.currentCatalog.getParent() != null) {
            File parent = this.currentCatalog.getParentFile();
            if (!parent.isDirectory()) {
                throw new ParadoxDataException(DataError.INVALID_CATALOG_PATH);
            }
            File[] catalogFiles = parent.listFiles(new DirectoryFilter(this.locale));
            if (catalogFiles != null) {
                catalogs.addAll(Arrays.stream(catalogFiles).filter(File::isDirectory).filter(catalog -> {
                    File[] schemas = catalog.listFiles(new DirectoryFilter(this.locale));
                    return schemas != null && schemas.length > 0;
                }).map(File::getName).collect(Collectors.toList()));
            }
        } else {
            catalogs.add(this.getCatalog());
        }
        catalogs.sort(String::compareTo);
        return catalogs;
    }

    public String getUrl() {
        return this.url;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isBcdRounding() {
        return this.bcdRounding;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Schema getCurrentSchema() {
        return this.currentSchema;
    }

    public void setCurrentSchema(String schemaName) throws SQLException {
        if (INFORMATION_SCHEMA.equalsIgnoreCase(schemaName)) {
            this.currentSchema = new SystemSchema(this, this.currentCatalog.getName());
        } else {
            File[] schemas = this.currentCatalog.listFiles(new DirectoryFilter(this.locale, schemaName));
            if (schemas == null || schemas.length != 1) {
                throw new ParadoxException(ParadoxException.Error.SCHEMA_NOT_FOUND);
            }
            this.currentSchema = new DirectorySchema(schemas[0]);
        }
    }

    public void setCurrentSchema(Schema currentSchema) {
        this.currentSchema = currentSchema;
    }

    public String getCatalog() {
        return this.currentCatalog.getName();
    }

    void setCurrentCatalog(File currentCatalog) {
        this.currentCatalog = currentCatalog;
    }

    public int getHoldability() {
        return this.holdability;
    }

    public void setHoldability(int holdability) {
        this.holdability = holdability;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public SQLWarning getWarning() {
        return this.warning;
    }

    public void addWarning(Exception exception) {
        SQLWarning warningToAdd;
        if (exception instanceof SQLException) {
            SQLException sql = (SQLException)exception;
            warningToAdd = new SQLWarning(sql.getMessage(), sql.getSQLState(), sql.getErrorCode(), sql);
        } else {
            warningToAdd = new SQLWarning(exception);
        }
        if (this.warning == null) {
            this.warning = warningToAdd;
        } else {
            this.warning.setNextWarning(warningToAdd);
        }
    }

    public void addWarning(String message) {
        SQLWarning warningToAdd = new SQLWarning(message);
        if (this.warning == null) {
            this.warning = warningToAdd;
        } else {
            this.warning.setNextWarning(warningToAdd);
        }
    }

    public void clearWarnings() {
        this.warning = null;
    }
}

