/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.stammdatenMV;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Alarm;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Alarme;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Aufgaben;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Beobachtung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Bilder;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Festpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Geographie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.GrundwasserHydrogeologie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.GrundwasserMessstelle;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hauptwerte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hydro;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Logger;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.LoggerKommunikation;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Messger\u00e4t;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Nullpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbau;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Referenz;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Rueckstau;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Sonstige;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Verwaltung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Vorg\u00e4nger;
import luwa.marlin.importer.stammdaten.repository.LadeRepository;
import luwa.marlin.importer.stammdaten.util.ConnectionHandler;

public class PegelRepository
implements LadeRepository {
    private final ConnectionHandler connection;

    public PegelRepository(ConnectionHandler connection) {
        this.connection = connection;
    }

    @Override
    public List<Pegelbezeichnungen> ladePegelbezeichnungen() {
        String sql = "SELECT * FROM public.psdb_dt_pegel";
        ArrayList<Pegelbezeichnungen> pegelbezeichnungen = new ArrayList<Pegelbezeichnungen>();
        this.connection.handle("Pegelbezeichnung", "SELECT * FROM public.psdb_dt_pegel", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            String standort = rs.getString("bezeichnung");
            String gewaesser = rs.getString("gewaesser");
            pegelbezeichnungen.add(new Pegelbezeichnungen((int)messstellen_nr, standort, gewaesser));
        });
        return pegelbezeichnungen;
    }

    @Override
    public List<Integer> ladeMessstellen() {
        String sql = "SELECT * FROM public.psdb_dt_pegel";
        ArrayList<Integer> messstellen = new ArrayList<Integer>();
        this.connection.handle("Messstellen", "SELECT * FROM public.psdb_dt_pegel", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            messstellen.add((int)messstellen_nr);
        });
        return messstellen;
    }

    @Override
    public List<Nullpunkte> ladeNullpunkte() {
        Map<Integer, Integer> vermessungsystem_mapping = Map.of(1, 0, 2, 10, 3, 9, 4, 2, 5, 3, 6, 7);
        String sql = "SELECT * FROM public.psdb_dt_pegel";
        ArrayList<Nullpunkte> nullpunkte = new ArrayList<Nullpunkte>();
        this.connection.handle("Nullpunkte", "SELECT * FROM public.psdb_dt_pegel", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            float nullpunkt = rs.getFloat("pnp");
            int vermessungssystem_mv_nr = rs.getInt("pnp_system");
            nullpunkte.add(new Nullpunkte((int)messstellen_nr, nullpunkt, (Integer)vermessungsystem_mapping.get(vermessungssystem_mv_nr)));
        });
        return nullpunkte;
    }

    @Override
    public List<Vorg\u00e4nger> ladeVorg\u00e4nger() {
        String sql = "SELECT public.psdb_dt_pegel.pegelkennzahl, vor.pegelkennzahl as vorgaengerkennzahl FROM public.psdb_dt_pegel join public.psdb_dt_pegel vor on vor.id = public.psdb_dt_pegel.vorgaengerpegel where public.psdb_dt_pegel.vorgaengerpegel is not null";
        ArrayList<Vorg\u00e4nger> vorgaengerList = new ArrayList<Vorg\u00e4nger>();
        this.connection.handle("Vorg\u00e4nger", "SELECT public.psdb_dt_pegel.pegelkennzahl, vor.pegelkennzahl as vorgaengerkennzahl FROM public.psdb_dt_pegel join public.psdb_dt_pegel vor on vor.id = public.psdb_dt_pegel.vorgaengerpegel where public.psdb_dt_pegel.vorgaengerpegel is not null", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            float vorgaenger = rs.getFloat("vorgaengerkennzahl") * 10.0f;
            vorgaengerList.add(new Vorg\u00e4nger((int)messstellen_nr, (int)vorgaenger));
        });
        return vorgaengerList;
    }

    @Override
    public List<Beobachtung> ladeBeobachtung() {
        String sql = "SELECT pegelkennzahl, beobachtungsbeginn, 1 as beobachtung_nr FROM public.psdb_dt_pegel where beobachtungsbeginn is not null";
        ArrayList<Beobachtung> beobachtungen = new ArrayList<Beobachtung>();
        this.connection.handle("Beobachtung", "SELECT pegelkennzahl, beobachtungsbeginn, 1 as beobachtung_nr FROM public.psdb_dt_pegel where beobachtungsbeginn is not null", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            int jahr = rs.getInt("beobachtungsbeginn") - 1900;
            Timestamp gueltig_von = new Timestamp(jahr, 0, 1, 0, 0, 0, 0);
            int beobachtung_nr = rs.getInt("beobachtung_nr");
            beobachtungen.add(new Beobachtung((int)messstellen_nr, beobachtung_nr, gueltig_von));
        });
        return beobachtungen;
    }

    @Override
    public List<Verwaltung> ladeVerwaltungen() {
        Map<Integer, Integer> zustaendigkeit_mapping = Map.of(1, 0, 2, 1, 3, 2, 4, 3, 5, 4, 7, 5, 11, 6, 12, 7, 13, 8, 14, 9);
        String sql = "SELECT pegelkennzahl, zustaendigkeit, zustaendigkeit2, gebietskennzahl, bearbeitungsgebiet, wsv_id, flussgebietskennzahl, fg_einheit, wrrl.bezeichnung as wrrl FROM public.psdb_dt_pegel join public.psdb_st_wrrl_wasserkoerper wrrl on wrrl.id = psdb_dt_pegel.wrrl_wasserkoerper";
        ArrayList<Verwaltung> verwaltungen = new ArrayList<Verwaltung>();
        this.connection.handle("Verwaltungen", "SELECT pegelkennzahl, zustaendigkeit, zustaendigkeit2, gebietskennzahl, bearbeitungsgebiet, wsv_id, flussgebietskennzahl, fg_einheit, wrrl.bezeichnung as wrrl FROM public.psdb_dt_pegel join public.psdb_st_wrrl_wasserkoerper wrrl on wrrl.id = psdb_dt_pegel.wrrl_wasserkoerper", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            int zustaendigkeit = rs.getInt("zustaendigkeit");
            int zustaendigkeit2 = rs.getInt("zustaendigkeit2");
            long gebietskennzahl = rs.getLong("gebietskennzahl");
            int bearbeitungsgebiet = rs.getInt("bearbeitungsgebiet") - 1;
            String wrrl = rs.getString("wrrl");
            int wsv_id = rs.getInt("wsv_id");
            long flussgebietskennzahl = rs.getLong("flussgebietskennzahl");
            int flussgebiets_nr = rs.getInt("fg_einheit") - 1;
            verwaltungen.add(new Verwaltung((int)messstellen_nr, bearbeitungsgebiet, gebietskennzahl, (Integer)zustaendigkeit_mapping.get(zustaendigkeit2), (Integer)zustaendigkeit_mapping.get(zustaendigkeit), flussgebietskennzahl, wsv_id, wrrl, flussgebiets_nr));
        });
        return verwaltungen;
    }

    @Override
    public List<Status> ladeStatus() {
        String sql = "SELECT * FROM public.psdb_dt_pegel";
        ArrayList<Status> status = new ArrayList<Status>();
        this.connection.handle("Status", "SELECT * FROM public.psdb_dt_pegel", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            String bemerkung = rs.getString("bemerkungen");
            int status_nr = rs.getBoolean("stillgelegt") ? 2 : 1;
            status.add(new Status((int)messstellen_nr, bemerkung, status_nr));
        });
        return status;
    }

    @Override
    public List<Alarme> ladeAlarme() {
        String sql = "SELECT * FROM public.psdb_dt_pegel where alarmstufe1 is not null or alarmstufe2 is not null or alarmstufe3 is not null or alarmstufe4 is not null";
        ArrayList<Alarme> alarmListe = new ArrayList<Alarme>();
        this.connection.handle("Alarme", "SELECT * FROM public.psdb_dt_pegel where alarmstufe1 is not null or alarmstufe2 is not null or alarmstufe3 is not null or alarmstufe4 is not null", rs -> {
            ArrayList<Integer> alarmwerte = new ArrayList<Integer>();
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            alarmwerte.add(rs.getInt("alarmstufe1"));
            alarmwerte.add(rs.getInt("alarmstufe2"));
            alarmwerte.add(rs.getInt("alarmstufe3"));
            alarmwerte.add(rs.getInt("alarmstufe4"));
            Alarme alarme = new Alarme((int)messstellen_nr);
            for (Integer wert : alarmwerte) {
                if (wert == null) continue;
                alarme.alarme.add(new Alarm(wert));
            }
            alarmListe.add(alarme);
        });
        return alarmListe;
    }

    @Override
    public List<Festpunkte> ladeFestpunkte() {
        String sql = "SELECT * FROM public.psdb_dt_pegel";
        ArrayList<Festpunkte> festpunkte = new ArrayList<Festpunkte>();
        this.connection.handle("Festpunkte", "SELECT * FROM public.psdb_dt_pegel", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            int rechtswert = rs.getInt("rechtswert");
            int hochwert = rs.getInt("hochwert");
            festpunkte.add(new Festpunkte((int)messstellen_nr, rechtswert, hochwert));
        });
        return festpunkte;
    }

    @Override
    public List<LoggerKommunikation> ladeKommunikation() {
        String sql = "SELECT pegelkennzahl, 1 as haupt FROM public.psdb_dt_pegel where datenfernuebertragung = 1 union SELECT pegelkennzahl, 0 as haupt FROM public.psdb_dt_pegel where redundanz_dfue_ds = 1";
        ArrayList<LoggerKommunikation> kommunikation = new ArrayList<LoggerKommunikation>();
        this.connection.handle("Logger Kommunikation", "SELECT pegelkennzahl, 1 as haupt FROM public.psdb_dt_pegel where datenfernuebertragung = 1 union SELECT pegelkennzahl, 0 as haupt FROM public.psdb_dt_pegel where redundanz_dfue_ds = 1", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            boolean haupt = rs.getBoolean("haupt");
            kommunikation.add(new LoggerKommunikation((int)messstellen_nr, haupt));
        });
        return kommunikation;
    }

    @Override
    public List<Logger> ladeLogger() {
        String sql = "SELECT pegelkennzahl, 1 as haupt FROM public.psdb_dt_pegel where datensammler = 1 union SELECT pegelkennzahl, 0 as haupt FROM public.psdb_dt_pegel where redundanz_dfue_ds = 1";
        ArrayList<Logger> logger = new ArrayList<Logger>();
        this.connection.handle("Logger", "SELECT pegelkennzahl, 1 as haupt FROM public.psdb_dt_pegel where datensammler = 1 union SELECT pegelkennzahl, 0 as haupt FROM public.psdb_dt_pegel where redundanz_dfue_ds = 1", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            boolean haupt = rs.getBoolean("haupt");
            logger.add(new Logger((int)messstellen_nr, haupt));
        });
        return logger;
    }

    @Override
    public List<Referenz> ladeReferenz() {
        String sql = "SELECT pegelkennzahl FROM public.psdb_dt_pegel where lattenpegel = 1";
        ArrayList<Referenz> referenz = new ArrayList<Referenz>();
        this.connection.handle("Referenz", "SELECT pegelkennzahl FROM public.psdb_dt_pegel where lattenpegel = 1", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            referenz.add(new Referenz((int)messstellen_nr));
        });
        return referenz;
    }

    @Override
    public List<Messger\u00e4t> ladeMessgeraet() {
        String sql = "SELECT pegelkennzahl, 1 as bezeichnung FROM public.psdb_dt_pegel where schreibpegel = 1 union SELECT pegelkennzahl, 2 as bezeichnung FROM public.psdb_dt_pegel where ultraschall = 1";
        ArrayList<Messger\u00e4t> messger\u00e4te = new ArrayList<Messger\u00e4t>();
        this.connection.handle("Messger\u00e4t", "SELECT pegelkennzahl, 1 as bezeichnung FROM public.psdb_dt_pegel where schreibpegel = 1 union SELECT pegelkennzahl, 2 as bezeichnung FROM public.psdb_dt_pegel where ultraschall = 1", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            int bezeichnung = rs.getInt("bezeichnung");
            messger\u00e4te.add(new Messger\u00e4t((int)messstellen_nr, bezeichnung));
        });
        return messger\u00e4te;
    }

    @Override
    public List<Geographie> ladeGeographie() {
        String sql = "SELECT pegelkennzahl, station, gewaesserkennzahl, einzugsgebiet, flaeche_mv, dlm25w FROM public.psdb_dt_pegel";
        ArrayList<Geographie> geographie = new ArrayList<Geographie>();
        this.connection.handle("Geographie", "SELECT pegelkennzahl, station, gewaesserkennzahl, einzugsgebiet, flaeche_mv, dlm25w FROM public.psdb_dt_pegel", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            float stationierung = rs.getFloat("station");
            long gewaesserkennzahl = rs.getLong("gewaesserkennzahl");
            float einzugsgebiet = rs.getFloat("einzugsgebiet");
            float einzugsgebiet_bl = rs.getFloat("flaeche_mv");
            int quelle_einzugsgebiet_nr = rs.getBoolean("dlm25w") ? 3 : 2;
            geographie.add(new Geographie((int)messstellen_nr, Float.valueOf(einzugsgebiet), gewaesserkennzahl, Float.valueOf(stationierung), Float.valueOf(einzugsgebiet_bl), quelle_einzugsgebiet_nr));
        });
        return geographie;
    }

    @Override
    public List<Rueckstau> ladeRueckstau() {
        String sql = "SELECT pegelkennzahl, 3 as art FROM public.psdb_dt_pegel where ostseerueckstau = 1 union SELECT pegelkennzahl, 0 as art FROM public.psdb_dt_pegel where ostseerueckstau = 0";
        ArrayList<Rueckstau> rueckstau = new ArrayList<Rueckstau>();
        this.connection.handle("R\u00dcckstau", "SELECT pegelkennzahl, 3 as art FROM public.psdb_dt_pegel where ostseerueckstau = 1 union SELECT pegelkennzahl, 0 as art FROM public.psdb_dt_pegel where ostseerueckstau = 0", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            int art_nr = rs.getInt("art");
            rueckstau.add(new Rueckstau((int)messstellen_nr, art_nr));
        });
        return rueckstau;
    }

    @Override
    public List<Aufgaben> ladeAufgaben() {
        String sql = "SELECT * FROM public.psdb_dt_pegel";
        ArrayList<Aufgaben> aufgabenListe = new ArrayList<Aufgaben>();
        this.connection.handle("Aufgaben", "SELECT * FROM public.psdb_dt_pegel", rs -> {
            boolean lsp;
            boolean datenaustausch;
            boolean dgj;
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            Aufgaben aufgaben = new Aufgaben((int)messstellen_nr);
            boolean hmo = rs.getBoolean("hwmdvo");
            if (hmo) {
                aufgaben.hydro.add(new Hydro(2));
            }
            if (dgj = rs.getBoolean("jahrbuchpegel")) {
                aufgaben.hydro.add(new Hydro(1));
            }
            if (datenaustausch = rs.getBoolean("mobil")) {
                aufgaben.hydro.add(new Hydro(6));
            }
            if (lsp = rs.getBoolean("aufg_lsp")) {
                aufgaben.sonstige.add(new Sonstige(50));
            }
            if (rs.getBoolean("aufg_oper")) {
                aufgaben.sonstige.add(new Sonstige(51));
            }
            if (rs.getBoolean("aufg_wmb")) {
                aufgaben.sonstige.add(new Sonstige(52));
            }
            if (rs.getBoolean("aufg_guet")) {
                aufgaben.sonstige.add(new Sonstige(53));
            }
            if (rs.getBoolean("aufg_ref")) {
                aufgaben.sonstige.add(new Sonstige(54));
            }
            if (rs.getBoolean("aufg_hydro")) {
                aufgaben.sonstige.add(new Sonstige(55));
            }
            if (rs.getBoolean("aufg_abfl")) {
                aufgaben.sonstige.add(new Sonstige(56));
            }
            if (rs.getBoolean("aufg_ezg")) {
                aufgaben.sonstige.add(new Sonstige(57));
            }
            if (rs.getBoolean("erlasspegel")) {
                aufgaben.sonstige.add(new Sonstige(58));
            }
            if (rs.getBoolean("online")) {
                aufgaben.sonstige.add(new Sonstige(59));
            }
            aufgabenListe.add(aufgaben);
        });
        return aufgabenListe;
    }

    @Override
    public List<Funktion> ladeFunktion() {
        String sql = "SELECT * FROM public.psdb_dt_pegel where pegeltyp != 205";
        ArrayList<Funktion> funktionen = new ArrayList<Funktion>();
        this.connection.handle("Funktion", "SELECT * FROM public.psdb_dt_pegel where pegeltyp != 205", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            boolean w = rs.getBoolean("messung_w");
            boolean q = rs.getBoolean("messung_q");
            boolean t = rs.getBoolean("messung_t");
            int pegeltyp = rs.getInt("pegeltyp");
            int messung = 0;
            if (!w && !q && t) {
                messung = 1;
            }
            if (!w && q && t) {
                messung = 2;
            }
            if (!w && q && !t) {
                messung = 3;
            }
            if (w && q && t) {
                messung = 4;
            }
            if (w && !q && t) {
                messung = 5;
            }
            if (w && q && !t) {
                messung = 6;
            }
            if (w && !q && !t) {
                messung = 7;
            }
            int art = 0;
            if (pegeltyp == 203) {
                art = 1;
            }
            if (pegeltyp == 202) {
                art = 2;
            }
            if (pegeltyp == 201) {
                art = 3;
            }
            int pegeltyp_nr = art == 0 || messung == 0 ? 0 : art * 7 + messung;
            funktionen.add(new Funktion((int)messstellen_nr, pegeltyp_nr));
        });
        return funktionen;
    }

    @Override
    public List<Bilder> ladeBilder() {
        String sql = "SELECT pegelkennzahl, dateiname FROM public.psdb_dt_fotos join public.psdb_dt_pegel pegel on pegel.id = pegel where dateiname not like 'foto_vorschau%'";
        ArrayList<Bilder> bilder = new ArrayList<Bilder>();
        this.connection.handle("Bilder", "SELECT pegelkennzahl, dateiname FROM public.psdb_dt_fotos join public.psdb_dt_pegel pegel on pegel.id = pegel where dateiname not like 'foto_vorschau%'", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            String name = rs.getString("dateiname");
            bilder.add(new Bilder((int)messstellen_nr, name));
        });
        return bilder;
    }

    @Override
    public List<Hauptwerte> ladeHauptwerteW() {
        String sql = "SELECT pegelkennzahl, endjahr FROM public.psdb_mv_zeitreihen join public.psdb_dt_pegel pegel on pegel.id = pegel where parameter = 1";
        ArrayList<Hauptwerte> hauptwerte = new ArrayList<Hauptwerte>();
        this.connection.handle("Bezugsperioden", "SELECT pegelkennzahl, endjahr FROM public.psdb_mv_zeitreihen join public.psdb_dt_pegel pegel on pegel.id = pegel where parameter = 1", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            int gesamtEnd = rs.getInt("endjahr");
            int endBezugsperiode = PegelRepository.getEndBezugsperiode(gesamtEnd);
            int startBezugsperiode = endBezugsperiode - 9;
            int parameter = 119;
            hauptwerte.add(new Hauptwerte((int)messstellen_nr, 'w', startBezugsperiode, endBezugsperiode));
        });
        PegelRepository.berechneHauptwerte(hauptwerte);
        return hauptwerte;
    }

    @Override
    public List<Hauptwerte> ladeHauptwerteQ() {
        String sql = "SELECT pegelkennzahl, endjahr FROM public.psdb_mv_zeitreihen join public.psdb_dt_pegel pegel on pegel.id = pegel where parameter = 2";
        ArrayList<Hauptwerte> hauptwerte = new ArrayList<Hauptwerte>();
        this.connection.handle("Bezugsperioden", "SELECT pegelkennzahl, endjahr FROM public.psdb_mv_zeitreihen join public.psdb_dt_pegel pegel on pegel.id = pegel where parameter = 2", rs -> {
            float messstellen_nr = rs.getFloat("pegelkennzahl") * 10.0f;
            int gesamtEnd = rs.getInt("endjahr");
            int endBezugsperiode = PegelRepository.getEndBezugsperiode(gesamtEnd);
            int startBezugsperiode = endBezugsperiode - 9;
            int parameter = 113;
            hauptwerte.add(new Hauptwerte((int)messstellen_nr, 'q', startBezugsperiode, endBezugsperiode));
        });
        PegelRepository.berechneHauptwerte(hauptwerte);
        return hauptwerte;
    }

    @Override
    public List<GrundwasserMessstelle> ladeGrundwasserMessstelle() {
        return Collections.emptyList();
    }

    @Override
    public List<GrundwasserHydrogeologie> ladeGrundwasserHydrogeologie() {
        return Collections.emptyList();
    }

    @Override
    public List<Pegelbau> ladePegelbau() {
        return Collections.emptyList();
    }

    private static void berechneHauptwerte(ArrayList<Hauptwerte> hauptwerte) {
        try {
            HttpClient client = HttpClient.newBuilder().build();
            for (Hauptwerte hauptwert : hauptwerte) {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(String.format("http://%s:%s/hauptwerte?station=%s&from_year=%s&to_year=%s&parameter=%s", System.getenv("MARLIN_SHIP_LIBRARY_HOST"), System.getenv("MARLIN_SHIP_LIBRARY_PORT"), hauptwert.metadaten.messstellen_nr, hauptwert.start, hauptwert.end, Character.valueOf(hauptwert.parameter)))).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                try {
                    JsonNode tree = new ObjectMapper().readTree(response.body());
                    hauptwert.n = PegelRepository.treeAsDouble(tree, "N");
                    hauptwert.nJahr = tree.get("N Jahr").asInt();
                    hauptwert.mn = PegelRepository.treeAsDouble(tree, "MN");
                    hauptwert.m = PegelRepository.treeAsDouble(tree, "M");
                    hauptwert.mh = PegelRepository.treeAsDouble(tree, "MH");
                    hauptwert.h = PegelRepository.treeAsDouble(tree, "H");
                    hauptwert.hJahr = tree.get("H Jahr").asInt();
                    hauptwert.nn = PegelRepository.treeAsDouble(tree, "NN");
                    hauptwert.nnDatum = PegelRepository.asDate(tree.get("NN Datum").asText());
                    hauptwert.hh = PegelRepository.treeAsDouble(tree, "HH");
                    hauptwert.hhDatum = PegelRepository.asDate(tree.get("HH Datum").asText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Date asDate(String date) {
        DateTimeFormatter datumsformat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        if (!date.isEmpty()) {
            LocalDate localDate = LocalDate.from(datumsformat.parse(date));
            return Date.valueOf(localDate);
        }
        return null;
    }

    private static double treeAsDouble(JsonNode tree, String field) {
        JsonNode node = tree.get(field);
        return node == null ? 0.0 : node.asDouble();
    }

    public static int getEndBezugsperiode(int gesamtEnd) {
        int faktor = gesamtEnd / 5;
        return faktor * 5;
    }
}

