/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.stammdatenBUKEA;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Alarme;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Aufgaben;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Beobachtung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Bilder;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Festpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Geographie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.GrundwasserHydrogeologie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.GrundwasserMessstelle;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hauptwerte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hydro;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Logger;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.LoggerKommunikation;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Messger\u00e4t;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Nullpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbau;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Referenz;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Rueckstau;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Verwaltung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Vorg\u00e4nger;
import luwa.marlin.importer.stammdaten.repository.LadeRepository;
import luwa.marlin.importer.stammdaten.repository.stammdatenBUKEA.ParameterTyp;
import luwa.marlin.importer.stammdaten.types.GWMessstelle;
import luwa.marlin.importer.stammdaten.types.Messstelle;
import luwa.marlin.importer.stammdaten.types.OWMessstelle;
import luwa.marlin.importer.stammdaten.types.ParameterMessger\u00e4te;
import luwa.marlin.importer.stammdaten.util.ConnectionHandler;

public class BukeaRepository
implements LadeRepository {
    private final ConnectionHandler connection;
    private final List<GWMessstelle> gw;
    private final List<OWMessstelle> ow;
    private final List<ParameterMessger\u00e4te> parameter;
    private final Map<Integer, Messstelle> messstellen;

    public BukeaRepository(ConnectionHandler connection, List<GWMessstelle> gw, List<OWMessstelle> ow, List<ParameterMessger\u00e4te> parameter) {
        this.connection = connection;
        this.gw = gw;
        this.ow = ow;
        this.parameter = parameter;
        this.messstellen = Stream.concat(gw.stream(), ow.stream()).collect(Collectors.toMap(rec$ -> ((Messstelle)rec$).messstellen_nr(), m -> (Messstelle)((Object)m)));
    }

    @Override
    public List<Integer> ladeMessstellen() {
        return this.messstellen.values().stream().filter(m -> m.zuImportieren() || m.importUnklar()).map(Messstelle::messstellen_nr).toList();
    }

    @Override
    public List<Pegelbezeichnungen> ladePegelbezeichnungen() {
        String sql = "SELECT     MS_NR,     MS_STRASSE,     MS_FERTIGSTELLUNGSDATUM,     fluss.FLG_BEZEICHNUNG FROM gero_dba.messstellen mess left outer join gero_dba.flussgebiete fluss on fluss.flg_id = mess.ms_flussgebiet";
        ArrayList<Pegelbezeichnungen> pegelbezeichnungen = new ArrayList<Pegelbezeichnungen>();
        this.connection.handle("Pegelbezeichnung", "SELECT     MS_NR,     MS_STRASSE,     MS_FERTIGSTELLUNGSDATUM,     fluss.FLG_BEZEICHNUNG FROM gero_dba.messstellen mess left outer join gero_dba.flussgebiete fluss on fluss.flg_id = mess.ms_flussgebiet", rs -> {
            String gewaesser;
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            String standort = this.limitTo(rs.getString("MS_STRASSE"), 95);
            String string = gewaesser = this.gwMessstelle(messstellen_nr) ? "" : this.limitTo(rs.getString("FLG_BEZEICHNUNG"), 95);
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                if (gueltig_von == null) {
                    pegelbezeichnungen.add(new Pegelbezeichnungen(messstellen_nr, standort, gewaesser));
                } else {
                    pegelbezeichnungen.add(new Pegelbezeichnungen(messstellen_nr, standort, gewaesser, gueltig_von));
                }
            }
        });
        return pegelbezeichnungen;
    }

    @Override
    public List<Nullpunkte> ladeNullpunkte() {
        return Collections.emptyList();
    }

    @Override
    public List<Vorg\u00e4nger> ladeVorg\u00e4nger() {
        return List.of();
    }

    @Override
    public List<Beobachtung> ladeBeobachtung() {
        return Collections.emptyList();
    }

    @Override
    public List<Verwaltung> ladeVerwaltungen() {
        String sql = "SELECT     MS_NR,     MS_EKZ_ID,     MS_FERTIGSTELLUNGSDATUM FROM gero_dba.messstellen mess where MS_EKZ_ID is not null";
        ArrayList<Verwaltung> verwaltung = new ArrayList<Verwaltung>();
        this.connection.handle("Verwaltung", "SELECT     MS_NR,     MS_EKZ_ID,     MS_FERTIGSTELLUNGSDATUM FROM gero_dba.messstellen mess where MS_EKZ_ID is not null", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            String eigent\u00fcmerBetreiber = rs.getString("MS_EKZ_ID").trim();
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                int eigent\u00fcmerBetreiberId;
                int n = eigent\u00fcmerBetreiberId = eigent\u00fcmerBetreiber.equals("-") ? 0 : Integer.parseInt(eigent\u00fcmerBetreiber);
                if (gueltig_von != null) {
                    verwaltung.add(new Verwaltung(messstellen_nr, eigent\u00fcmerBetreiberId, eigent\u00fcmerBetreiberId, gueltig_von));
                } else {
                    verwaltung.add(new Verwaltung(messstellen_nr, eigent\u00fcmerBetreiberId, eigent\u00fcmerBetreiberId));
                }
            }
        });
        return verwaltung;
    }

    @Override
    public List<Status> ladeStatus() {
        String sql = "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     MS_STILLLEGUNGSDATUM,     MS_AUSSERBETRIEBNAHMEDATUM FROM gero_dba.messstellen";
        ArrayList<Status> status = new ArrayList<Status>();
        this.connection.handle("Status", "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     MS_STILLLEGUNGSDATUM,     MS_AUSSERBETRIEBNAHMEDATUM FROM gero_dba.messstellen", rs -> {
            Timestamp fertigstellung = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            Timestamp stilllegung = rs.getTimestamp("MS_STILLLEGUNGSDATUM");
            Timestamp au\u00dferBetrieb = rs.getTimestamp("MS_AUSSERBETRIEBNAHMEDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            if (this.zuImportieren(messstellen_nr)) {
                if (fertigstellung != null) {
                    status.add(new Status(messstellen_nr, "", 1, fertigstellung));
                }
                if (stilllegung != null) {
                    status.add(new Status(messstellen_nr, "", 6, stilllegung));
                }
                if (au\u00dferBetrieb != null) {
                    status.add(new Status(messstellen_nr, "", 2, au\u00dferBetrieb));
                }
            }
            if (this.importUnklar(messstellen_nr)) {
                status.add(new Status(messstellen_nr, "", 0));
            }
        });
        return status;
    }

    @Override
    public List<Alarme> ladeAlarme() {
        return Collections.emptyList();
    }

    @Override
    public List<Festpunkte> ladeFestpunkte() {
        return Collections.emptyList();
    }

    @Override
    public List<LoggerKommunikation> ladeKommunikation() {
        return Collections.emptyList();
    }

    @Override
    public List<Logger> ladeLogger() {
        String sql = "SELECT     dl.GWM_NR,     logger_datum,     LOGGER_NR,     LOGGER_BEM,     case when ins.OFFLINE_DL = 1 then 3 else case when ins.ONLINE_DL = 1 then 1 else case when ins.OHNE_DL = 1 then 4 else 0 end end end as datenuebermittlung FROM DIWA_DBA.TBL_DATENLOGGER dl left outer join DIWA_DBA.tbl_gwm_inspektion ins on ins.GWM_NR = dl.GWM_NR";
        ArrayList<Logger> logger = new ArrayList<Logger>();
        this.connection.handle("Logger", "SELECT     dl.GWM_NR,     logger_datum,     LOGGER_NR,     LOGGER_BEM,     case when ins.OFFLINE_DL = 1 then 3 else case when ins.ONLINE_DL = 1 then 1 else case when ins.OHNE_DL = 1 then 4 else 0 end end end as datenuebermittlung FROM DIWA_DBA.TBL_DATENLOGGER dl left outer join DIWA_DBA.tbl_gwm_inspektion ins on ins.GWM_NR = dl.GWM_NR", rs -> {
            String[] dateString = rs.getString("logger_datum").split(" ");
            Timestamp gueltig_von = Timestamp.valueOf(LocalDateTime.parse(dateString[0] + " 00:00", DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm")));
            int messstellen_nr = rs.getInt("GWM_NR");
            int logger_nr = rs.getInt("LOGGER_NR");
            String bemerkung = rs.getString("LOGGER_BEM");
            int datenuebermittlung = rs.getInt("datenuebermittlung");
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                logger.add(new Logger(messstellen_nr, 1, logger_nr, 1, datenuebermittlung, gueltig_von, bemerkung));
            }
        });
        return logger;
    }

    @Override
    public List<Referenz> ladeReferenz() {
        return Collections.emptyList();
    }

    @Override
    public List<Messger\u00e4t> ladeMessgeraet() {
        return this.parameter.stream().map(pm -> new Messger\u00e4t(pm.messstellen_nr(), this.asParameterId(pm.messung(), pm.einheit(), ParameterTyp.Messger\u00e4t), Timestamp.valueOf(pm.start()))).toList();
    }

    @Override
    public List<Geographie> ladeGeographie() {
        String sql = "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     diwa.lage,     diwa.station FROM gero_dba.messstellen mess LEFT OUTER JOIN diwa_dba.TBL_DIPS_STAMMDAT diwa on diwa.STA_MS_NR = mess.MS_NR";
        ArrayList<Geographie> geo = new ArrayList<Geographie>();
        this.connection.handle("Geographie", "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     diwa.lage,     diwa.station FROM gero_dba.messstellen mess LEFT OUTER JOIN diwa_dba.TBL_DIPS_STAMMDAT diwa on diwa.STA_MS_NR = mess.MS_NR", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            Integer lage = this.asLageId(rs.getInt("lage"));
            float station = rs.getFloat("station");
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                geo.add(new Geographie(messstellen_nr, gueltig_von, lage, Float.valueOf(station)));
            }
        });
        return geo;
    }

    @Override
    public List<Rueckstau> ladeRueckstau() {
        return Collections.emptyList();
    }

    @Override
    public List<Aufgaben> ladeAufgaben() {
        String sql = "SELECT MS_NR, MS_FERTIGSTELLUNGSDATUM, UPOG, UPTIG, WRRL, WSG, PWS FROM gero_dba.messstellen left outer join DIWA_DBA.TBL_GWM_INSPEKTION on GWM_NR = MS_NR where UPOG is not null or UPTIG is not null or WRRL is not null or PWS is not null";
        ArrayList<Aufgaben> aufgaben = new ArrayList<Aufgaben>();
        this.connection.handle("Aufgaben", "SELECT MS_NR, MS_FERTIGSTELLUNGSDATUM, UPOG, UPTIG, WRRL, WSG, PWS FROM gero_dba.messstellen left outer join DIWA_DBA.TBL_GWM_INSPEKTION on GWM_NR = MS_NR where UPOG is not null or UPTIG is not null or WRRL is not null or PWS is not null", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                boolean pws;
                boolean wsg;
                boolean wrrl;
                boolean uptig;
                Aufgaben aufgabe = new Aufgaben(messstellen_nr, gueltig_von);
                boolean upog = rs.getBoolean("UPOG");
                if (upog) {
                    aufgabe.hydro.add(new Hydro(1));
                }
                if (uptig = rs.getBoolean("UPTIG")) {
                    aufgabe.hydro.add(new Hydro(2));
                }
                if (wrrl = rs.getBoolean("WRRL")) {
                    aufgabe.hydro.add(new Hydro(3));
                }
                if (wsg = rs.getBoolean("WSG")) {
                    aufgabe.hydro.add(new Hydro(4));
                }
                if (pws = rs.getBoolean("PWS")) {
                    aufgabe.hydro.add(new Hydro(5));
                }
                aufgaben.add(aufgabe);
            }
        });
        return aufgaben;
    }

    @Override
    public List<Funktion> ladeFunktion() {
        String sql = "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM FROM gero_dba.messstellen mess";
        ArrayList<Funktion> funktion = new ArrayList<Funktion>();
        this.connection.handle("Funktion", "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM FROM gero_dba.messstellen mess", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                funktion.add(new Funktion(messstellen_nr, this.gwMessstelle(messstellen_nr) ? 3 : 2, this.messstellen.get(messstellen_nr).messnetz(), this.getParameterId(messstellen_nr), gueltig_von));
            }
        });
        return funktion;
    }

    @Override
    public List<Bilder> ladeBilder() {
        return Collections.emptyList();
    }

    @Override
    public List<Hauptwerte> ladeHauptwerteW() {
        return Collections.emptyList();
    }

    @Override
    public List<Hauptwerte> ladeHauptwerteQ() {
        return Collections.emptyList();
    }

    @Override
    public List<GrundwasserMessstelle> ladeGrundwasserMessstelle() {
        String sql = "WITH gh_dates AS (     SELECT         MSG_MS_NR,         MSG_GUELTIGKEITSDATUM,         ROW_NUMBER() OVER (PARTITION BY MSG_MS_NR ORDER BY MSG_GUELTIGKEITSDATUM DESC) AS rn_gh     FROM gero_dba.EINMESSUNGEN_NEU     WHERE MSG_ART = 'GH' ) SELECT     e.MSG_MS_NR,     e.MSG_GUELTIGKEITSDATUM,     MAX(CASE WHEN e.MSG_ART = 'MP' THEN e.MSG_HOEHE END) AS Messpunkth\u00f6he,     MAX(CASE WHEN e.MSG_ART = 'GH' THEN e.MSG_HOEHE END) AS Gel\u00e4ndeoberkante,     MAX(CASE             WHEN e.MSG_ART = 'GH' AND gh.rn_gh = 1 THEN e.MSG_HOEHE - m.MS_FILTERUNTERKANTE - m.MS_FILTERLAENGE         END) AS Filteroberkante_unter_GOK,     MAX(CASE             WHEN e.MSG_ART = 'GH' AND gh.rn_gh = 1 THEN e.MSG_HOEHE - m.MS_FILTERUNTERKANTE         END) AS Filterunterkante_unter_GOK FROM gero_dba.EINMESSUNGEN_NEU e LEFT JOIN gero_dba.MESSSTELLEN m     ON m.MS_NR = e.MSG_MS_NR LEFT JOIN gh_dates gh     ON e.MSG_MS_NR = gh.MSG_MS_NR    AND e.MSG_GUELTIGKEITSDATUM = gh.MSG_GUELTIGKEITSDATUM GROUP BY     e.MSG_MS_NR,     e.MSG_GUELTIGKEITSDATUM";
        ArrayList<GrundwasserMessstelle> gw = new ArrayList<GrundwasserMessstelle>();
        this.connection.handle("Grundwasser Messstelle", "WITH gh_dates AS (     SELECT         MSG_MS_NR,         MSG_GUELTIGKEITSDATUM,         ROW_NUMBER() OVER (PARTITION BY MSG_MS_NR ORDER BY MSG_GUELTIGKEITSDATUM DESC) AS rn_gh     FROM gero_dba.EINMESSUNGEN_NEU     WHERE MSG_ART = 'GH' ) SELECT     e.MSG_MS_NR,     e.MSG_GUELTIGKEITSDATUM,     MAX(CASE WHEN e.MSG_ART = 'MP' THEN e.MSG_HOEHE END) AS Messpunkth\u00f6he,     MAX(CASE WHEN e.MSG_ART = 'GH' THEN e.MSG_HOEHE END) AS Gel\u00e4ndeoberkante,     MAX(CASE             WHEN e.MSG_ART = 'GH' AND gh.rn_gh = 1 THEN e.MSG_HOEHE - m.MS_FILTERUNTERKANTE - m.MS_FILTERLAENGE         END) AS Filteroberkante_unter_GOK,     MAX(CASE             WHEN e.MSG_ART = 'GH' AND gh.rn_gh = 1 THEN e.MSG_HOEHE - m.MS_FILTERUNTERKANTE         END) AS Filterunterkante_unter_GOK FROM gero_dba.EINMESSUNGEN_NEU e LEFT JOIN gero_dba.MESSSTELLEN m     ON m.MS_NR = e.MSG_MS_NR LEFT JOIN gh_dates gh     ON e.MSG_MS_NR = gh.MSG_MS_NR    AND e.MSG_GUELTIGKEITSDATUM = gh.MSG_GUELTIGKEITSDATUM GROUP BY     e.MSG_MS_NR,     e.MSG_GUELTIGKEITSDATUM", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MSG_GUELTIGKEITSDATUM");
            int messstellen_nr = rs.getInt("MSG_MS_NR");
            Float messpunkth\u00f6he = this.getNullableFloat(rs, "Messpunkth\u00f6he");
            Float gel\u00e4ndeoberkante = this.getNullableFloat(rs, "Gel\u00e4ndeoberkante");
            Float fo = this.getNullableFloat(rs, "Filteroberkante_unter_GOK");
            Float fu = this.getNullableFloat(rs, "Filterunterkante_unter_GOK");
            if (this.gwMessstelle(messstellen_nr) && (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr))) {
                gw.add(new GrundwasserMessstelle(messstellen_nr, null, gel\u00e4ndeoberkante, messpunkth\u00f6he, fo, fu, gueltig_von));
            }
        });
        return gw;
    }

    @Override
    public List<GrundwasserHydrogeologie> ladeGrundwasserHydrogeologie() {
        String sql = "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     MS_AQUIFERZUORDNUNG1,     MS_AQUIFERZUORDNUNG3,     CASE WHEN MS_FOERDERUNG = 'J' THEN 'Wasserf\u00f6rderung' ELSE CASE WHEN MS_EINLEITUNG = 'J' THEN 'Wassereinleitung' ELSE '' END END as beeinflussung FROM gero_dba.messstellen mess where MS_AQUIFERZUORDNUNG1 is not null or MS_AQUIFERZUORDNUNG3 is not null or MS_FOERDERUNG = 'J' or MS_EINLEITUNG = 'J'";
        ArrayList<GrundwasserHydrogeologie> gw = new ArrayList<GrundwasserHydrogeologie>();
        this.connection.handle("Grundwasser Hydrogeologie", "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     MS_AQUIFERZUORDNUNG1,     MS_AQUIFERZUORDNUNG3,     CASE WHEN MS_FOERDERUNG = 'J' THEN 'Wasserf\u00f6rderung' ELSE CASE WHEN MS_EINLEITUNG = 'J' THEN 'Wassereinleitung' ELSE '' END END as beeinflussung FROM gero_dba.messstellen mess where MS_AQUIFERZUORDNUNG1 is not null or MS_AQUIFERZUORDNUNG3 is not null or MS_FOERDERUNG = 'J' or MS_EINLEITUNG = 'J'", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            String grundwasserk\u00f6rper = rs.getString("MS_AQUIFERZUORDNUNG1");
            String hydrostratigraphie = rs.getString("MS_AQUIFERZUORDNUNG1");
            String beeinflussung = rs.getString("beeinflussung");
            if (this.gwMessstelle(messstellen_nr) && (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr))) {
                gw.add(new GrundwasserHydrogeologie(messstellen_nr, this.asGWKId(grundwasserk\u00f6rper), this.asHydrostratigraphieId(hydrostratigraphie), beeinflussung, gueltig_von));
            }
        });
        return gw;
    }

    @Override
    public List<Pegelbau> ladePegelbau() {
        String sql = "((select MS_NR, MS_FERTIGSTELLUNGSDATUM as guelig_von, 1 as pegelbau_nr from GERO_DBA.MESSSTELLEN where MS_FERTIGSTELLUNGSDATUM is not null) union all (select MS_NR, MS_AUSSERBETRIEBNAHMEDATUM as guelig_von, 0 as pegelbau_nr from GERO_DBA.MESSSTELLEN where MS_AUSSERBETRIEBNAHMEDATUM is not null))";
        ArrayList<Pegelbau> pegelbau = new ArrayList<Pegelbau>();
        this.connection.handle("Pegelbau", "((select MS_NR, MS_FERTIGSTELLUNGSDATUM as guelig_von, 1 as pegelbau_nr from GERO_DBA.MESSSTELLEN where MS_FERTIGSTELLUNGSDATUM is not null) union all (select MS_NR, MS_AUSSERBETRIEBNAHMEDATUM as guelig_von, 0 as pegelbau_nr from GERO_DBA.MESSSTELLEN where MS_AUSSERBETRIEBNAHMEDATUM is not null))", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("guelig_von");
            int messstellen_nr = rs.getInt("MS_NR");
            int pegelbau_nr = rs.getInt("pegelbau_nr");
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                pegelbau.add(new Pegelbau(messstellen_nr, pegelbau_nr, gueltig_von));
            }
        });
        return pegelbau;
    }

    private String limitTo(String text, int limit) {
        return text == null || text.length() < limit ? text : text.substring(0, limit);
    }

    private boolean zuImportieren(int messstellen_nr) {
        return this.messstellen.containsKey(messstellen_nr) && this.messstellen.get(messstellen_nr).zuImportieren();
    }

    private boolean importUnklar(int messstellen_nr) {
        return this.messstellen.containsKey(messstellen_nr) && this.messstellen.get(messstellen_nr).importUnklar();
    }

    private boolean gwMessstelle(int messstellen_nr) {
        return this.gw.stream().map(GWMessstelle::messstellen_nr).anyMatch(messstellen -> messstellen == messstellen_nr);
    }

    private int asMessnetzId(boolean landesmessnetz) {
        if (landesmessnetz) {
            return 1;
        }
        return 0;
    }

    private Integer asGWKId(String grundwasserk\u00f6rper) {
        if (grundwasserk\u00f6rper == null) {
            return null;
        }
        return switch (grundwasserk\u00f6rper) {
            case "L1" -> 1;
            case "L1-L2" -> 2;
            case "L2-LH3" -> 3;
            case "L3" -> 4;
            case "L4.1" -> 5;
            case "L4.2" -> 6;
            case "L5" -> 7;
            case "L6" -> 8;
            case "LH7" -> 9;
            case "OBKS" -> 10;
            default -> 0;
        };
    }

    private Integer asHydrostratigraphieId(String hydrostratigraphie) {
        if (hydrostratigraphie == null) {
            return null;
        }
        return switch (hydrostratigraphie) {
            case "L1" -> 1;
            case "L1-L2" -> 2;
            case "L2" -> 3;
            case "L2-LH3" -> 4;
            case "L3" -> 5;
            case "L4.1" -> 6;
            case "L4.2" -> 7;
            case "L4.3" -> 8;
            case "L5" -> 9;
            case "L6" -> 10;
            case "LH3" -> 11;
            case "LH7" -> 12;
            default -> 0;
        };
    }

    private Integer asLageId(Integer lage) {
        if (lage == null) {
            return null;
        }
        return switch (lage) {
            case 2 -> 3;
            case 3 -> 2;
            default -> lage;
        };
    }

    private int getParameterId(int messstellenNr) {
        return this.parameter.stream().filter(mg -> mg.messstellen_nr() == messstellenNr).findFirst().map(mg -> this.asParameterId(mg.messung(), mg.einheit(), ParameterTyp.Pegel)).orElse(0);
    }

    private int asParameterId(String messung, String einheit, ParameterTyp typ) {
        return switch (messung) {
            case "ABSTICH" -> {
                if (einheit.equals("1cm")) {
                    if (typ == ParameterTyp.Pegel) {
                        yield 3;
                    }
                    yield 6;
                }
                yield 11;
            }
            case "NN" -> {
                if (einheit.equals("1cm")) {
                    yield 1;
                }
                yield 12;
            }
            default -> 0;
        };
    }
}

