/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.pegeldaten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class InsertRepository {
    protected Connection connection;

    protected <T> void handleMultiInsertConnection(String name, String sql, List<T> liste, MultiInsertAction<T> action) {
        this.handleMultiInsertConnection(name, sql, liste, true, action);
    }

    protected <T> void handleMultiInsertConnection(String name, String sql, List<T> liste, boolean log, MultiInsertAction<T> action) {
        String[] generatedKeyColumns = new String[]{"id"};
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            for (T item : liste) {
                int index = 1;
                action.act(stmt, item, index);
                stmt.addBatch();
            }
            stmt.executeBatch();
            if (log) {
                System.out.printf("%s importiert: %s%n", name, liste.size());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Konnte %s nicht in SQL-Datenbank einf\u00fcgen: %s", name, e.getMessage()), e);
        }
    }

    protected int handleSingleInsertConnection(String name, String sql, SingleInsertAction action) {
        int n;
        block8: {
            String[] generatedKeyColumns = new String[]{"id"};
            PreparedStatement stmt = this.connection.prepareStatement(sql, generatedKeyColumns);
            try {
                int index = 1;
                action.act(stmt, index);
                stmt.execute();
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                generatedKeys.next();
                n = generatedKeys.getInt(1);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(String.format("Konnte %s nicht in SQL-Datenbank einf\u00fcgen: %s", name, e.getMessage()), e);
                }
            }
            stmt.close();
        }
        return n;
    }

    protected void nullableNumber(PreparedStatement stmt, int index, Number wert, int sqlType) throws SQLException {
        if (wert != null) {
            switch (sqlType) {
                case 4: {
                    stmt.setInt(index, wert.intValue());
                    break;
                }
                case 6: {
                    stmt.setFloat(index, wert.floatValue());
                    break;
                }
                case 8: {
                    stmt.setDouble(index, wert.doubleValue());
                    break;
                }
                case -5: {
                    stmt.setLong(index, wert.longValue());
                    break;
                }
                default: {
                    stmt.setObject(index, (Object)wert, sqlType);
                    break;
                }
            }
        } else {
            stmt.setNull(index, sqlType);
        }
    }

    protected static interface MultiInsertAction<T> {
        public void act(PreparedStatement var1, T var2, int var3) throws SQLException;
    }

    protected static interface SingleInsertAction {
        public void act(PreparedStatement var1, int var2) throws SQLException;
    }
}

