/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.pegeldaten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Betriebspegel;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Bilder;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Metadaten;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.InsertRepository;

public class GeneralRepository
extends InsertRepository {
    private final boolean isOracle;

    public GeneralRepository(Connection connection, boolean isOracle) {
        this.isOracle = isOracle;
        this.connection = connection;
    }

    public int speichereMetadaten(Metadaten metadaten) {
        String sql = "INSERT INTO pegeldaten.sd_metadaten (id, messstelle_nr, kategorie_id, ersteller_nr, erfasst_am, bemerkung) VALUES (" + (this.isOracle ? "SD_METADATEN_SEQ.nextval" : "nextval('sd_metadaten_id_seq')") + ", ?, ?, ?, ?, ?)";
        return this.handleSingleInsertConnection("Metadaten", sql, (stmt, index) -> {
            stmt.setLong(index++, metadaten.messstellen_nr);
            stmt.setInt(index++, metadaten.kategorie_id);
            stmt.setInt(index++, metadaten.ersteller_nr);
            stmt.setDate(index++, metadaten.erfasst_am);
            stmt.setString(index++, metadaten.bemerkung);
        });
    }

    public void speichereMessstellen(List<Integer> messstellen) {
        String sql = "INSERT INTO pegeldaten.sd_messstellen (messstelle_nr) VALUES (?)";
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO pegeldaten.sd_messstellen (messstelle_nr) VALUES (?)");){
            for (Integer messstelle : messstellen) {
                int index = 1;
                stmt.setInt(index++, messstelle);
                stmt.addBatch();
            }
            stmt.executeBatch();
            System.out.printf("Messstellennummern importiert: %s%n", messstellen.size());
        }
        catch (SQLException e) {
            throw new RuntimeException("Konnte Messstellen nicht in SQL-Datenbank einf\u00fcgen: " + e.getMessage(), e);
        }
    }

    public void refreshMaterializedViews() {
        this.refreshStmts().forEach(sql -> {
            try (PreparedStatement stmt = this.connection.prepareStatement((String)sql);){
                stmt.execute();
            }
            catch (SQLException e) {
                throw new RuntimeException("Konnte Materialized Views nicht aktualisieren: " + e.getMessage(), e);
            }
        });
        System.out.println("* Materialized Views aktualisiert *");
    }

    private List<String> refreshStmts() {
        List<String> sqlListPostgres = List.of("refresh materialized view mv_sd_logger", "refresh materialized view mv_sd_logger_kommunikation", "refresh materialized view mv_sd_massgeb_gewaesserab", "refresh materialized view mv_sd_messgeraet", "refresh materialized view mv_sd_messgeraet_kommunikation", "refresh materialized view mv_sd_nullpunkte", "refresh materialized view mv_sd_pegelbau", "refresh materialized view mv_sd_pegelschau", "refresh materialized view mv_sd_relevante_werte", "refresh materialized view mv_sd_ska", "refresh materialized view mv_sd_standortqualitaet", "refresh materialized view mv_sd_vorgaengerhistorie", "refresh materialized view mv_sd_pegelbezeichnung", "refresh materialized view mv_sd_aufgaben", "refresh materialized view mv_sd_funktion", "refresh materialized view mv_sd_beobachtung", "refresh materialized view mv_sd_status", "refresh materialized view mv_sd_geographie", "refresh materialized view mv_sd_verwaltung", "refresh materialized view mv_sd_pegeldaten", "refresh materialized view mv_sd_hauptwerte_wasserstand", "refresh materialized view mv_sd_hauptwerte_durchfluss", "refresh materialized view mv_sd_hw_wiederkehr", "refresh materialized view mv_sd_rueckstau", "refresh materialized view mv_sd_pegeldaten");
        List<String> sqlListOracle = List.of("BEGIN dbms_mview.refresh('mv_sd_logger'); END;", "BEGIN dbms_mview.refresh('mv_sd_logger_kommunikation'); END;", "BEGIN dbms_mview.refresh('mv_sd_massgeb_gewaesserab'); END;", "BEGIN dbms_mview.refresh('mv_sd_messgeraet'); END;", "BEGIN dbms_mview.refresh('mv_sd_messgeraet_kommunikation'); END;", "BEGIN dbms_mview.refresh('mv_sd_nullpunkte'); END;", "BEGIN dbms_mview.refresh('mv_sd_pegelbau'); END;", "BEGIN dbms_mview.refresh('mv_sd_pegelschau'); END;", "BEGIN dbms_mview.refresh('mv_sd_relevante_werte'); END;", "BEGIN dbms_mview.refresh('mv_sd_ska'); END;", "BEGIN dbms_mview.refresh('mv_sd_standortqualitaet'); END;", "BEGIN dbms_mview.refresh('mv_sd_vorgaengerhistorie'); END;", "BEGIN dbms_mview.refresh('mv_sd_pegelbezeichnung'); END;", "BEGIN dbms_mview.refresh('mv_sd_aufgaben'); END;", "BEGIN dbms_mview.refresh('mv_sd_funktion'); END;", "BEGIN dbms_mview.refresh('mv_sd_beobachtung'); END;", "BEGIN dbms_mview.refresh('mv_sd_status'); END;", "BEGIN dbms_mview.refresh('mv_sd_geographie'); END;", "BEGIN dbms_mview.refresh('mv_sd_verwaltung'); END;", "BEGIN dbms_mview.refresh('mv_sd_pegeldaten'); END;", "BEGIN dbms_mview.refresh('mv_sd_hauptwerte_wasserstand'); END;", "BEGIN dbms_mview.refresh('mv_sd_hauptwerte_durchfluss'); END;", "BEGIN dbms_mview.refresh('mv_sd_hw_wiederkehr'); END;", "BEGIN dbms_mview.refresh('mv_sd_rueckstau'); END;", "BEGIN dbms_mview.refresh('MV_SD_GW_MESSSTELLE'); END;", "BEGIN dbms_mview.refresh('mv_sd_pegeldaten'); END;");
        return this.isOracle ? sqlListOracle : sqlListPostgres;
    }

    public void deleteAllStammdaten() {
        List<String> sqlList = List.of("truncate table SD_KD_STATUS", "truncate table SD_FUNKTION_PARAMETER", "truncate table SD_KD_FUNKTION", "truncate table SD_AUFGABEN_SONSTIGE", "truncate table SD_ALARME_WERTE", "truncate table SD_AUFGABEN_HYDROLOG_MESSNETZ", "truncate table SD_AP_MGT_LOGGER_KOMMUNIKA", "truncate table SD_KD_GEOGRAPHIE", "truncate table SD_KD_PEGELBEZEICHNUNG", "truncate table SD_KD_VERWALTUNG", "truncate table SD_KD_BEOBACHTUNG", "truncate table SD_REFERENZEN_WERTE", "truncate table SD_MESSSTELLEN", "truncate table SD_FESTPUNKTE_WERTE", "truncate table SD_AP_MGT_LOGGER", "truncate table SD_AP_MGT_MESSGERAET", "truncate table SD_AP_VERFAHRANLAGEN_SKA", "truncate table SD_KD_KETTE_VORGAENGERHISTORIE", "truncate table SD_KD_PEGELBAU", "truncate table SD_KD_VERMESSUNG_NULLPUNKTE", "truncate table sd_ap_rueckstau", "truncate table SD_KD_GW_MESSSTELLE", "truncate table ohyd.photos", "delete from SD_KD_ALARME", "delete from SD_KD_AUFGABEN", "delete from SD_AP_MGT_REFERENZ", "delete from SD_KD_VERMESSUNG_FESTPUNKTE", "delete from SD_METADATEN", "delete from ohyd.messtelle_pegel where messtellen_nr = 1");
        sqlList.forEach(sql -> {
            try (PreparedStatement stmt = this.connection.prepareStatement((String)sql);){
                stmt.execute();
            }
            catch (SQLException e) {
                throw new RuntimeException("Konnte alte Stammdaten nicht l\u00f6schen: " + e.getMessage(), e);
            }
        });
        System.out.println("* Tabellen geleert *");
    }

    public Betriebspegel ladeBetriebspegel() {
        String sql = "SELECT messtellen_nr, standort, gewaesser, bemerkung_allgemein FROM ohyd.messtelle_pegel WHERE messtellen_nr not in (select messstelle_nr from sd_messstellen)";
        ArrayList<Integer> messstelle = new ArrayList<Integer>();
        ArrayList<Pegelbezeichnungen> pegelbezeichnung = new ArrayList<Pegelbezeichnungen>();
        ArrayList<Status> status = new ArrayList<Status>();
        ArrayList<Funktion> funktion = new ArrayList<Funktion>();
        try (PreparedStatement query = this.connection.prepareStatement("SELECT messtellen_nr, standort, gewaesser, bemerkung_allgemein FROM ohyd.messtelle_pegel WHERE messtellen_nr not in (select messstelle_nr from sd_messstellen)");
             ResultSet rs = query.executeQuery();){
            while (rs.next()) {
                int messstellen_nr = rs.getInt("messtellen_nr");
                String bemerkung = rs.getString("bemerkung_allgemein");
                String standort = rs.getString("standort");
                String gewaesser = rs.getString("gewaesser");
                messstelle.add(messstellen_nr);
                status.add(new Status(messstellen_nr, bemerkung, 1));
                pegelbezeichnung.add(new Pegelbezeichnungen(messstellen_nr, standort, gewaesser));
                funktion.add(new Funktion(messstellen_nr, 7));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Konnte Betriebspegel nicht aus SQL-Datenbank auslesen: %s", e.getMessage()), e);
        }
        return new Betriebspegel(messstelle, pegelbezeichnung, status, funktion);
    }

    public void speichereBilderOHYD(List<Bilder> bilder) {
        String sql = "INSERT INTO ohyd.photos (gauging_station_id, image_file_name) VALUES (?, ?)";
        this.handleMultiInsertConnection("Bilder", "INSERT INTO ohyd.photos (gauging_station_id, image_file_name) VALUES (?, ?)", bilder, (stmt, bild, index) -> {
            stmt.setInt(index++, bild.messstellen_nr);
            stmt.setString(index++, bild.name);
        });
    }
}

