/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ConnectionHandler {
    private final Connection connection;

    public ConnectionHandler(Connection connection) {
        this.connection = connection;
    }

    public void handle(String name, String sql, ConnectionAction action) {
        try (PreparedStatement query = this.connection.prepareStatement(sql);
             ResultSet rs = query.executeQuery();){
            while (rs.next()) {
                action.act(rs);
            }
        }
        catch (SQLException e) {
            System.out.printf("Konnte %s nicht aus SQL-Datenbank auslesen: %s%n", name, e.getMessage());
        }
    }

    public static interface ConnectionAction {
        public void act(ResultSet var1) throws SQLException;
    }
}

