/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.stammdatenBUKEA;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Alarme;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Aufgaben;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Beobachtung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Bilder;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Festpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Geographie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hauptwerte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Logger;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.LoggerKommunikation;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Messger\u00e4t;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Nullpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Referenz;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Rueckstau;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Verwaltung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Vorg\u00e4nger;
import luwa.marlin.importer.stammdaten.repository.LadeRepository;
import luwa.marlin.importer.stammdaten.types.GWMessstelle;
import luwa.marlin.importer.stammdaten.types.Messstelle;
import luwa.marlin.importer.stammdaten.types.OWMessstelle;
import luwa.marlin.importer.stammdaten.types.ParameterMessger\u00e4te;
import luwa.marlin.importer.stammdaten.util.ConnectionHandler;

public class BukeaRepository
implements LadeRepository {
    private final ConnectionHandler connection;
    private final List<GWMessstelle> gw;
    private final List<OWMessstelle> ow;
    private final List<ParameterMessger\u00e4te> parameter;
    private final Map<Integer, Messstelle> messstellen;

    public BukeaRepository(ConnectionHandler connection, List<GWMessstelle> gw, List<OWMessstelle> ow, List<ParameterMessger\u00e4te> parameter) {
        this.connection = connection;
        this.gw = gw;
        this.ow = ow;
        this.parameter = parameter;
        this.messstellen = Stream.concat(gw.stream(), ow.stream()).collect(Collectors.toMap(rec$ -> ((Messstelle)rec$).messstellen_nr(), m -> (Messstelle)((Object)m)));
    }

    @Override
    public List<Integer> ladeMessstellen() {
        return this.messstellen.values().stream().filter(m -> m.zuImportieren() || m.importUnklar()).map(Messstelle::messstellen_nr).toList();
    }

    @Override
    public List<Pegelbezeichnungen> ladePegelbezeichnungen() {
        String sql = "SELECT     MS_NR,     MS_LAGE,     MS_FERTIGSTELLUNGSDATUM,     fluss.FLG_BEZEICHNUNG FROM gero_dba.messstellen mess left outer join gero_dba.flussgebiete fluss on fluss.flg_id = mess.ms_flussgebiet";
        ArrayList<Pegelbezeichnungen> pegelbezeichnungen = new ArrayList<Pegelbezeichnungen>();
        this.connection.handle("Pegelbezeichnung", "SELECT     MS_NR,     MS_LAGE,     MS_FERTIGSTELLUNGSDATUM,     fluss.FLG_BEZEICHNUNG FROM gero_dba.messstellen mess left outer join gero_dba.flussgebiete fluss on fluss.flg_id = mess.ms_flussgebiet", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            String standort = this.limitTo(rs.getString("MS_LAGE"), 95);
            String gewaesser = this.limitTo(rs.getString("FLG_BEZEICHNUNG"), 95);
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                if (gueltig_von == null) {
                    pegelbezeichnungen.add(new Pegelbezeichnungen(messstellen_nr, standort, gewaesser));
                } else {
                    pegelbezeichnungen.add(new Pegelbezeichnungen(messstellen_nr, standort, gewaesser, gueltig_von));
                }
            }
        });
        return pegelbezeichnungen;
    }

    @Override
    public List<Nullpunkte> ladeNullpunkte() {
        return Collections.emptyList();
    }

    @Override
    public List<Vorg\u00e4nger> ladeVorg\u00e4nger() {
        return List.of();
    }

    @Override
    public List<Beobachtung> ladeBeobachtung() {
        return Collections.emptyList();
    }

    @Override
    public List<Verwaltung> ladeVerwaltungen() {
        String sql = "SELECT     MS_NR,     MS_EKZ_ID,     MS_FERTIGSTELLUNGSDATUM FROM gero_dba.messstellen mess where MS_EKZ_ID is not null";
        ArrayList<Verwaltung> verwaltung = new ArrayList<Verwaltung>();
        this.connection.handle("Verwaltung", "SELECT     MS_NR,     MS_EKZ_ID,     MS_FERTIGSTELLUNGSDATUM FROM gero_dba.messstellen mess where MS_EKZ_ID is not null", rs -> {
            Timestamp gueltig_von = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            String eigent\u00fcmer = rs.getString("MS_EKZ_ID").trim();
            if (this.zuImportieren(messstellen_nr) || this.importUnklar(messstellen_nr)) {
                int eigent\u00fcmerId;
                int n = eigent\u00fcmerId = eigent\u00fcmer.equals("-") ? 0 : Integer.parseInt(eigent\u00fcmer);
                if (gueltig_von != null) {
                    verwaltung.add(new Verwaltung(messstellen_nr, eigent\u00fcmerId, gueltig_von));
                } else {
                    verwaltung.add(new Verwaltung(messstellen_nr, eigent\u00fcmerId));
                }
            }
        });
        return verwaltung;
    }

    @Override
    public List<Status> ladeStatus() {
        String sql = "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     MS_STILLLEGUNGSDATUM,     MS_AUSSERBETRIEBNAHMEDATUM FROM gero_dba.messstellen";
        ArrayList<Status> status = new ArrayList<Status>();
        this.connection.handle("Status", "SELECT     MS_NR,     MS_FERTIGSTELLUNGSDATUM,     MS_STILLLEGUNGSDATUM,     MS_AUSSERBETRIEBNAHMEDATUM FROM gero_dba.messstellen", rs -> {
            Timestamp fertigstellung = rs.getTimestamp("MS_FERTIGSTELLUNGSDATUM");
            Timestamp stilllegung = rs.getTimestamp("MS_STILLLEGUNGSDATUM");
            Timestamp au\u00dferBetrieb = rs.getTimestamp("MS_AUSSERBETRIEBNAHMEDATUM");
            int messstellen_nr = rs.getInt("MS_NR");
            if (this.zuImportieren(messstellen_nr)) {
                if (fertigstellung != null) {
                    status.add(new Status(messstellen_nr, "", 1, fertigstellung));
                }
                if (stilllegung != null) {
                    status.add(new Status(messstellen_nr, "", 6, stilllegung));
                }
                if (au\u00dferBetrieb != null) {
                    status.add(new Status(messstellen_nr, "", 2, au\u00dferBetrieb));
                }
            }
            if (this.importUnklar(messstellen_nr)) {
                status.add(new Status(messstellen_nr, "", 0));
            }
        });
        return status;
    }

    @Override
    public List<Alarme> ladeAlarme() {
        return Collections.emptyList();
    }

    @Override
    public List<Festpunkte> ladeFestpunkte() {
        return Collections.emptyList();
    }

    @Override
    public List<LoggerKommunikation> ladeKommunikation() {
        return Collections.emptyList();
    }

    @Override
    public List<Logger> ladeLogger() {
        return Collections.emptyList();
    }

    @Override
    public List<Referenz> ladeReferenz() {
        return Collections.emptyList();
    }

    @Override
    public List<Messger\u00e4t> ladeMessgeraet() {
        return Collections.emptyList();
    }

    @Override
    public List<Geographie> ladeGeographie() {
        return Collections.emptyList();
    }

    @Override
    public List<Rueckstau> ladeRueckstau() {
        return Collections.emptyList();
    }

    @Override
    public List<Aufgaben> ladeAufgaben() {
        return Collections.emptyList();
    }

    @Override
    public List<Funktion> ladeFunktion() {
        return Collections.emptyList();
    }

    @Override
    public List<Bilder> ladeBilder() {
        return Collections.emptyList();
    }

    @Override
    public List<Hauptwerte> ladeHauptwerteW() {
        return Collections.emptyList();
    }

    @Override
    public List<Hauptwerte> ladeHauptwerteQ() {
        return Collections.emptyList();
    }

    private String limitTo(String text, int limit) {
        return text == null || text.length() < limit ? text : text.substring(0, limit);
    }

    private boolean zuImportieren(int messstellen_nr) {
        return this.messstellen.containsKey(messstellen_nr) && this.messstellen.get(messstellen_nr).zuImportieren();
    }

    private boolean importUnklar(int messstellen_nr) {
        return this.messstellen.containsKey(messstellen_nr) && this.messstellen.get(messstellen_nr).importUnklar();
    }
}

