/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.repository.pegeldaten;

import java.sql.Connection;
import java.util.List;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Alarme;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Aufgaben;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Beobachtung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Festpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Geographie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hauptwerte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Nullpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Verwaltung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Vorg\u00e4nger;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.GeneralRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.InsertRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.Schl\u00fcssellistenRepository;

public class KerndatenRepository
extends InsertRepository {
    public final GeneralRepository generalRepository;
    private final Schl\u00fcssellistenRepository schl\u00fcssellistenRepository;
    private final boolean isOracle;

    public KerndatenRepository(Connection connection, GeneralRepository generalRepository, Schl\u00fcssellistenRepository schl\u00fcssellistenRepository, boolean isOracle) {
        this.schl\u00fcssellistenRepository = schl\u00fcssellistenRepository;
        this.isOracle = isOracle;
        this.connection = connection;
        this.generalRepository = generalRepository;
    }

    public void speicherePegelbezeichnungen(List<Pegelbezeichnungen> pegelbezeichnungen) {
        String sql = "INSERT INTO pegeldaten.sd_kd_pegelbezeichnung (id, metadaten_id, gueltig_von, standort, gewaesser) VALUES (" + (this.isOracle ? "sd_pegelbezeichnung_seq.nextval" : "nextval('sd_kd_pegelbezeichnung_id_seq')") + ", ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Pegelbezeichnung", sql, pegelbezeichnungen, (stmt, pegelbezeichnung, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(pegelbezeichnung.metadaten));
            stmt.setTimestamp(index++, pegelbezeichnung.gueltig_von);
            stmt.setString(index++, pegelbezeichnung.standort);
            stmt.setString(index++, pegelbezeichnung.gewaesser);
        });
    }

    public void speichereNullpunkte(List<Nullpunkte> nullpunkte) {
        this.schl\u00fcssellistenRepository.erweitereVermessungssysteme();
        String sql = "INSERT INTO pegeldaten.sd_kd_vermessung_nullpunkte (id, metadaten_id, gueltig_von, pegelnullpunkt_vermessungsergebnis, vermessungssystem_vermessungsergebnis_nr, pegelnullpunkt, vermessungssystem_nr) VALUES (" + (this.isOracle ? "sd_nullpunkte_seq.nextval" : "nextval('sd_kd_vermessung_nullpunkte_id_seq')") + ", ?, ?, ?, ?, ?, 7)";
        this.handleMultiInsertConnection("Nullpunkte", sql, nullpunkte, (stmt, nullpunkt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(nullpunkt.metadaten));
            stmt.setTimestamp(index++, nullpunkt.gueltig_von);
            stmt.setFloat(index++, nullpunkt.nullpunkt);
            stmt.setInt(index++, nullpunkt.vermessungssystem_nr);
            if (nullpunkt.vermessungssystem_nr == 7) {
                stmt.setFloat(index++, nullpunkt.nullpunkt);
            } else {
                stmt.setNull(index++, 6);
            }
        });
    }

    public void speichereVorg\u00e4nger(List<Vorg\u00e4nger> vorg\u00e4ngerListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_kette_vorgaengerhistorie (id, metadaten_id, gueltig_von, vorgaenger_nr) VALUES (" + (this.isOracle ? "sd_vorgaengerhistorie_seq.nextval" : "nextval('sd_kd_kette_vorgaengerhistorie_id_seq')") + ", ?, ?, ?)";
        this.handleMultiInsertConnection("Vorg\u00e4nger", sql, vorg\u00e4ngerListe, (stmt, vorg\u00e4nger, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(vorg\u00e4nger.metadaten));
            stmt.setTimestamp(index++, vorg\u00e4nger.gueltig_von);
            stmt.setInt(index++, vorg\u00e4nger.vorg\u00e4nger);
        });
    }

    public void speichereNachfolger(List<Vorg\u00e4nger> vorg\u00e4ngerListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_kette_vorgaengerhistorie (id, metadaten_id, gueltig_von, nachfolger_nr) VALUES (" + (this.isOracle ? "sd_vorgaengerhistorie_seq.nextval" : "nextval('sd_kd_kette_vorgaengerhistorie_id_seq')") + ", ?, ?, ?)";
        this.handleMultiInsertConnection("Nachfolger", sql, vorg\u00e4ngerListe, (stmt, vorg\u00e4nger, index) -> {
            int nachfolger = vorg\u00e4nger.metadaten.messstellen_nr;
            vorg\u00e4nger.metadaten.messstellen_nr = vorg\u00e4nger.vorg\u00e4nger;
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(vorg\u00e4nger.metadaten));
            stmt.setTimestamp(index++, vorg\u00e4nger.gueltig_von);
            stmt.setInt(index++, nachfolger);
        });
    }

    public void speichereBeobachtung(List<Beobachtung> beobachtungen) {
        String sql = "INSERT INTO pegeldaten.sd_kd_beobachtung (id, metadaten_id, gueltig_von, beobachtung_nr) VALUES (" + (this.isOracle ? "sd_beobachtung_seq.nextval" : "nextval('sd_kd_beobachtung_id_seq')") + ", ?, ?, ?)";
        this.handleMultiInsertConnection("Beobachtung", sql, beobachtungen, (stmt, beobachtung, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(beobachtung.metadaten));
            stmt.setTimestamp(index++, beobachtung.gueltig_von);
            stmt.setInt(index++, beobachtung.beobachtung_nr);
        });
    }

    public void speichereVerwaltungen(List<Verwaltung> verwaltungen) {
        this.schl\u00fcssellistenRepository.erweitereFlussgebiet();
        this.schl\u00fcssellistenRepository.erweitereBearbeitungsgebiet();
        this.schl\u00fcssellistenRepository.erweitereBetreiber();
        this.schl\u00fcssellistenRepository.erweitereEigent\u00fcmer();
        String sql = "INSERT INTO pegeldaten.sd_kd_verwaltung (id, metadaten_id, gueltig_von, bearbeitungsgebiet_nr, gebietskennzahl, flussgebiet_nr, flussgebietskennzahl, wrrl_wk, wsv_id, betreiber_nr, eigentuemer_nr) VALUES (" + (this.isOracle ? "sd_verwaltung_seq.nextval" : "nextval('sd_kd_verwaltung_id_seq')") + ", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Verwaltung", sql, verwaltungen, (stmt, verwaltung, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(verwaltung.metadaten));
            stmt.setTimestamp(index++, verwaltung.gueltig_von);
            stmt.setObject(index++, (Object)verwaltung.bearbeitungsgebiet_nr, 4);
            stmt.setObject(index++, (Object)verwaltung.gebietskennzahl, -5);
            stmt.setObject(index++, (Object)verwaltung.flussgebiets_nr, 4);
            stmt.setObject(index++, (Object)verwaltung.flussgebietskennzahl, -5);
            stmt.setString(index++, verwaltung.wrrl_wk);
            stmt.setObject(index++, (Object)verwaltung.wsv_id, 4);
            stmt.setObject(index++, (Object)verwaltung.betreiber_nr, 4);
            stmt.setObject(index++, (Object)verwaltung.eigentuemer_nr, 4);
        });
    }

    public void speichereStatus(List<Status> statusListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_status (id, metadaten_id, gueltig_von, status, allgemeiner_hinweistext) VALUES (" + (this.isOracle ? "sd_status_seq.nextval" : "nextval('sd_kd_status_id_seq')") + ", ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Status", sql, statusListe, (stmt, status, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(status.metadaten));
            stmt.setTimestamp(index++, status.gueltig_von);
            stmt.setInt(index++, status.status_nr);
            stmt.setString(index++, status.hinweis);
        });
    }

    public void speichereAlarme(List<Alarme> alarme) {
        String sql = "INSERT INTO pegeldaten.sd_alarme_werte (id, alarme_id, meldewert, typ_nr, hmo_nr) VALUES (" + (this.isOracle ? "sd_alarme_werte_seq.nextval" : "nextval('sd_alarme_werte_id_seq')") + ", ?, ?, ?, ?)";
        for (Alarme alarm : alarme) {
            int alarm_id = this.speichereAlarm(alarm);
            this.handleMultiInsertConnection("Alarme", sql, alarm.alarme, false, (stmt, alarmwerte, index) -> {
                stmt.setInt(index++, alarm_id);
                stmt.setInt(index++, alarmwerte.meldewert);
                stmt.setInt(index++, alarmwerte.typ_nr);
                stmt.setInt(index++, alarmwerte.hmo_nr);
            });
        }
        System.out.printf("Alarme importiert: %s%n", alarme.size());
    }

    public int speichereAlarm(Alarme alarme) {
        String sql = "INSERT INTO pegeldaten.sd_kd_alarme (id, metadaten_id, gueltig_von) VALUES (" + (this.isOracle ? "sd_alarme_seq.nextval" : "nextval('sd_kd_alarme_id_seq')") + ", ?, ?)";
        return this.handleSingleInsertConnection("Alarm", sql, (stmt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(alarme.metadaten));
            stmt.setTimestamp(index++, alarme.gueltig_von);
        });
    }

    public void speichereFestpunkte(List<Festpunkte> festpunkte) {
        String sql = "INSERT INTO pegeldaten.sd_festpunkte_werte (id, festpunkte_id, nr, rechtswert, hochwert, massgeblich_nr) VALUES (" + (this.isOracle ? "sd_festpunkte_werte_seq.nextval" : "nextval('sd_festpunkte_werte_id_seq')") + ", ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Festpunkte", sql, festpunkte, (stmt, festpunkt, index) -> {
            int festpunkt_id = this.speichereFestpunkt((Festpunkte)festpunkt);
            stmt.setInt(index++, festpunkt_id);
            stmt.setInt(index++, festpunkt.nr);
            stmt.setInt(index++, festpunkt.rechtswert);
            stmt.setInt(index++, festpunkt.hochwert);
            stmt.setInt(index++, festpunkt.massgeblich_nr);
        });
    }

    public int speichereFestpunkt(Festpunkte festpunkte) {
        String sql = "INSERT INTO pegeldaten.sd_kd_vermessung_festpunkte (id, metadaten_id, gueltig_von) VALUES (" + (this.isOracle ? "sd_festpunkte_seq.nextval" : "nextval('sd_kd_vermessung_festpunkte_id_seq')") + ", ?, ?)";
        return this.handleSingleInsertConnection("Festpunkt", sql, (stmt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(festpunkte.metadaten));
            stmt.setTimestamp(index++, festpunkte.gueltig_von);
        });
    }

    public void speichereGeographie(List<Geographie> geographieListe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_geographie (id, metadaten_id, gueltig_von, einzugsgebiet, einzugsgebiet_bundesland, quelle_einzugsgebiet_nr, gewaesserkennzahl, stationierung) VALUES (" + (this.isOracle ? "sd_geographie_seq.nextval" : "nextval('sd_kd_geographie_id_seq')") + ", ?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Geographie", sql, geographieListe, (stmt, geographie, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(geographie.metadaten));
            stmt.setTimestamp(index++, geographie.gueltig_von);
            stmt.setFloat(index++, geographie.einzugsgebiet.floatValue());
            stmt.setFloat(index++, geographie.einzugsgebiet_bundesland.floatValue());
            stmt.setInt(index++, geographie.quelle_einzugsgebiet_nr);
            stmt.setLong(index++, geographie.gewaesserkennzahl);
            stmt.setFloat(index++, geographie.stationierung.floatValue());
        });
    }

    public void speichereAufgaben(List<Aufgaben> aufgaben) {
        this.schl\u00fcssellistenRepository.erweitereSonstigeAufgaben();
        String sqlSonstige = "INSERT INTO pegeldaten.sd_aufgaben_sonstige (id, aufgaben_id, sonstige_nr) VALUES (" + (this.isOracle ? "sd_aufgaben_sonstige_seq.nextval" : "nextval('sd_aufgaben_sonstige_id_seq')") + ", ?, ?)";
        String sqlHydro = "INSERT INTO pegeldaten.sd_aufgaben_hydrolog_messnetz (id, aufgaben_id, hydrologisches_messnetz_nr) VALUES (" + (this.isOracle ? "sd_aufgaben_hydrologisches_messnetz_seq.nextval" : "nextval('sd_aufgaben_hydrolog_messnetz_id_seq')") + ", ?, ?)";
        for (Aufgaben aufgabe : aufgaben) {
            int aufgabe_id = this.speichereAufgabe(aufgabe);
            this.handleMultiInsertConnection("Sonstige Aufgaben", sqlSonstige, aufgabe.sonstige, false, (stmt, sonstige, index) -> {
                stmt.setInt(index++, aufgabe_id);
                stmt.setInt(index++, sonstige.sonstige_nr);
            });
            this.handleMultiInsertConnection("Aufgaben hydrologisches Messnetz", sqlHydro, aufgabe.hydro, false, (stmt, hydro, index) -> {
                stmt.setInt(index++, aufgabe_id);
                stmt.setInt(index++, hydro.hydrologisches_messnetz_nr);
            });
        }
        System.out.printf("Aufgaben importiert: %s%n", aufgaben.size());
    }

    public int speichereAufgabe(Aufgaben aufgabe) {
        String sql = "INSERT INTO pegeldaten.sd_kd_aufgaben (id, metadaten_id, gueltig_von) VALUES (" + (this.isOracle ? "sd_aufgaben_seq.nextval" : "nextval('sd_kd_aufgaben_id_seq')") + ", ?, ?)";
        return this.handleSingleInsertConnection("Aufgabe", sql, (stmt, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(aufgabe.metadaten));
            stmt.setTimestamp(index++, aufgabe.gueltig_von);
        });
    }

    public void speichereFunktion(List<Funktion> funktionen) {
        this.schl\u00fcssellistenRepository.erweiterePegeltyp();
        String sql = "INSERT INTO pegeldaten.sd_kd_funktion (id, metadaten_id, gueltig_von, pegeltyp_nr, messnetz_nr) VALUES (" + (this.isOracle ? "sd_funktion_seq.nextval" : "nextval('sd_kd_funktion_id_seq')") + ", ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Funktion", sql, funktionen, (stmt, funktion, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(funktion.metadaten));
            stmt.setTimestamp(index++, funktion.gueltig_von);
            stmt.setFloat(index++, funktion.pegeltyp_nr);
            stmt.setInt(index++, funktion.messnetz_nr);
        });
    }

    public void speichereHauptwerteW(List<Hauptwerte> hauptwerte) {
        String sql = "INSERT INTO pegeldaten.sd_kd_hauptwerte_wasserstand (id, metadaten_id, gueltig_von, bezugsperiode_von, bezugsperiode_bis, nw, nw_jahr, mnw, mw, mhw, hw, hw_jahr, nnw, nnw_datum, hhw, hhw_datum) VALUES (" + (this.isOracle ? "sd_hauptwerte_wasserstand_seq.nextval" : "nextval('sd_kd_hauptwerte_wasserstand_id_seq')") + ", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Hauptwerte W", sql, hauptwerte, (stmt, hauptwert, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(hauptwert.metadaten));
            stmt.setTimestamp(index++, hauptwert.gueltig_von);
            stmt.setInt(index++, hauptwert.start);
            stmt.setInt(index++, hauptwert.end);
            stmt.setInt(index++, (int)hauptwert.n);
            stmt.setInt(index++, hauptwert.nJahr);
            stmt.setInt(index++, (int)hauptwert.mn);
            stmt.setInt(index++, (int)hauptwert.m);
            stmt.setInt(index++, (int)hauptwert.mh);
            stmt.setInt(index++, (int)hauptwert.h);
            stmt.setInt(index++, hauptwert.hJahr);
            stmt.setInt(index++, (int)hauptwert.nn);
            stmt.setDate(index++, hauptwert.nnDatum);
            stmt.setInt(index++, (int)hauptwert.hh);
            stmt.setDate(index++, hauptwert.hhDatum);
        });
    }

    public void speichereHauptwerteQ(List<Hauptwerte> hauptwerte) {
        String sql = "INSERT INTO pegeldaten.sd_kd_hauptwerte_durchfluss (id, metadaten_id, gueltig_von, bezugsperiode_von, bezugsperiode_bis, nq, nq_jahr, mnq, mq, mhq, hq, hq_jahr, nnq, nnq_datum, hhq, hhq_datum) VALUES (" + (this.isOracle ? "sd_hauptwerte_durchfluss_seq.nextval" : "nextval('sd_kd_hauptwerte_durchfluss_id_seq')") + ", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.handleMultiInsertConnection("Hauptwerte Q", sql, hauptwerte, (stmt, hauptwert, index) -> {
            stmt.setInt(index++, this.generalRepository.speichereMetadaten(hauptwert.metadaten));
            stmt.setTimestamp(index++, hauptwert.gueltig_von);
            stmt.setInt(index++, hauptwert.start);
            stmt.setInt(index++, hauptwert.end);
            stmt.setDouble(index++, hauptwert.n);
            stmt.setInt(index++, hauptwert.nJahr);
            stmt.setDouble(index++, hauptwert.mn);
            stmt.setDouble(index++, hauptwert.m);
            stmt.setDouble(index++, hauptwert.mh);
            stmt.setDouble(index++, hauptwert.h);
            stmt.setInt(index++, hauptwert.hJahr);
            stmt.setDouble(index++, hauptwert.nn);
            stmt.setDate(index++, hauptwert.nnDatum);
            stmt.setDouble(index++, hauptwert.hh);
            stmt.setDate(index++, hauptwert.hhDatum);
        });
    }
}

