/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.periphery;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSVLoader {
    private static final Logger logger = Logger.getLogger(CSVLoader.class.getName());

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> lesenAus(File csvFile, Class<T> zeilenClass) {
        if (csvFile == null || !csvFile.exists() || !csvFile.isFile()) {
            logger.warning("CSV-File nicht gefunden");
            return Collections.emptyList();
        }
        CsvMapper mapper = new CsvMapper();
        mapper.registerModule(new JavaTimeModule());
        CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator(';');
        try (FileInputStream input = new FileInputStream(csvFile);){
            List list;
            block14: {
                MappingIterator it = mapper.readerFor(zeilenClass).with(schema).readValues(input);
                try {
                    List result = it.readAll();
                    logger.info(() -> "Successfully read " + result.size() + " rows from " + csvFile.getName());
                    list = result;
                    if (it == null) break block14;
                }
                catch (Throwable throwable) {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                it.close();
            }
            return list;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to read CSV file: " + csvFile.getAbsolutePath(), e);
            return Collections.emptyList();
        }
    }
}

